/*
 * Decompiled with CFR 0.152.
 */
package io.pleo.prop.guice.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.pleo.prop.core.internal.ParserFactory;
import io.pleo.prop.jackson.FailedToParsePropValueException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class JacksonParserFactory
implements ParserFactory {
    private final Map<Type, Function<String, Object>> knownParsers = new HashMap<Type, Function<String, Object>>();
    private final ObjectMapper objectMapper;

    public JacksonParserFactory() {
        this(new ObjectMapper());
    }

    public JacksonParserFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.knownParsers.put((Type)((Object)String.class), s -> s);
        this.knownParsers.put((Type)((Object)Boolean.class), Boolean::valueOf);
        this.knownParsers.put((Type)((Object)Integer.class), Integer::valueOf);
        this.knownParsers.put((Type)((Object)Float.class), Float::valueOf);
        this.knownParsers.put((Type)((Object)Double.class), Double::valueOf);
        this.knownParsers.put((Type)((Object)BigDecimal.class), BigDecimal::new);
        this.knownParsers.put((Type)((Object)Duration.class), Duration::parse);
        this.knownParsers.put((Type)((Object)Instant.class), Instant::parse);
    }

    public Map<Type, Function<String, Object>> getKnownParsers() {
        return this.knownParsers;
    }

    public Function<String, Object> createParserForType(Type type) {
        return this.knownParsers.computeIfAbsent(type, t -> rawValue -> this.parse((String)rawValue, (Type)t));
    }

    private Object parse(String rawValue, Type type) {
        try {
            return this.objectMapper.readValue(rawValue, TypeFactory.defaultInstance().constructType(type));
        }
        catch (IOException | RuntimeException ex) {
            throw new FailedToParsePropValueException(ex);
        }
    }
}

