/*
 * Decompiled with CFR 0.152.
 */
package j15r.webgl.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.user.client.Timer;
import com.google.gwt.webgl.client.ArrayUtils;
import com.google.gwt.webgl.client.WebGLBuffer;
import com.google.gwt.webgl.client.WebGLFramebuffer;
import com.google.gwt.webgl.client.WebGLProgram;
import com.google.gwt.webgl.client.WebGLRenderbuffer;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import com.google.gwt.webgl.client.WebGLTexture;
import com.google.gwt.webgl.client.WebGLUniformLocation;
import com.google.gwt.webgl.client.WebGLUtil;
import j15r.webgl.client.Shaders;

public class WebGLDemo
implements EntryPoint {
    private static final int CANVAS_WIDTH = 640;
    private static final int CANVAS_HEIGHT = 480;
    private WebGLBuffer buffer;
    private WebGLBuffer indexBuffer;
    private WebGLProgram shaderProgram;
    private float[] projectionMatrix;
    private float[] modelViewMatrix;
    protected CanvasElement canvas;
    protected WebGLRenderingContext gl;
    private WebGLTexture birdTexture;
    private WebGLFramebuffer fbuf;

    private static native ImageElement createImage();

    private static native void hookOnLoad(ImageElement var0, EventHandler var1);

    public void onModuleLoad() {
        this.canvas = (CanvasElement)Document.get().createElement("canvas").cast();
        Document.get().getBody().appendChild((Node)this.canvas);
        this.canvas.setWidth(640);
        this.canvas.setHeight(480);
        this.gl = WebGLRenderingContext.getContext(this.canvas);
        this.gl.viewport(0, 0, 640, 480);
        this.init();
        new Timer(){

            public void run() {
                WebGLDemo.this.draw();
            }
        }.scheduleRepeating(100);
    }

    private void drawToFramebuffer() {
        this.gl.bindFramebuffer(36160, this.fbuf);
        this.gl.clear(16640);
        this.gl.bindTexture(3553, this.birdTexture);
        this.drawQuad();
        this.gl.bindTexture(3553, null);
        this.gl.bindFramebuffer(36160, null);
    }

    private void draw() {
        this.gl.bindFramebuffer(36160, null);
        this.gl.clear(16640);
        this.gl.bindTexture(3553, this.birdTexture);
        this.drawQuad();
        this.gl.bindTexture(3553, null);
    }

    private void drawQuad() {
        this.gl.useProgram(this.shaderProgram);
        WebGLUniformLocation pUniform = this.gl.getUniformLocation(this.shaderProgram, "projectionMatrix");
        this.gl.uniformMatrix4fv(pUniform, false, this.projectionMatrix);
        WebGLUniformLocation mvUniform = this.gl.getUniformLocation(this.shaderProgram, "modelViewMatrix");
        this.gl.uniformMatrix4fv(mvUniform, false, this.modelViewMatrix);
        this.gl.activeTexture(33984);
        this.gl.uniform1i(this.gl.getUniformLocation(this.shaderProgram, "texture"), 0);
        this.gl.bindBuffer(34962, this.buffer);
        int vertexPositionAttribute = this.gl.getAttribLocation(this.shaderProgram, "vertexPosition");
        this.gl.vertexAttribPointer(vertexPositionAttribute, 3, 5126, false, 0, 0);
        this.gl.enableVertexAttribArray(vertexPositionAttribute);
        int texCoordAttribute = this.gl.getAttribLocation(this.shaderProgram, "texCoord");
        this.gl.vertexAttribPointer(texCoordAttribute, 2, 5126, false, 0, 48);
        this.gl.enableVertexAttribArray(texCoordAttribute);
        this.gl.bindBuffer(34963, this.indexBuffer);
        this.gl.drawArrays(5, 0, 4);
    }

    private void init() {
        this.gl.clearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.gl.enable(3553);
        this.gl.enable(3042);
        this.gl.blendFunc(770, 771);
        this.projectionMatrix = new float[]{0.003125f, 0.0f, 0.0f, 0.0f, 0.0f, 0.004166667f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        this.modelViewMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        this.birdTexture = this.createTexture("/bird.png");
        this.shaderProgram = WebGLUtil.createShaderProgram(this.gl, Shaders.INSTANCE.vertexShader().getText(), Shaders.INSTANCE.fragmentShader().getText());
        this.initVertexBuffer();
    }

    private WebGLTexture createTexture() {
        WebGLTexture tex = this.gl.createTexture();
        this.gl.bindTexture(3553, tex);
        this.gl.texParameteri(3553, 10240, 9729);
        this.gl.texParameteri(3553, 10241, 9729);
        this.gl.texParameteri(3553, 10242, 33071);
        this.gl.texParameteri(3553, 10243, 33071);
        return tex;
    }

    private WebGLFramebuffer createFramebuffer(int width, int height) {
        WebGLTexture tex = this.createTexture();
        this.fbuf = this.gl.createFramebuffer();
        this.gl.texImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, null);
        WebGLRenderbuffer rbuf = this.gl.createRenderbuffer();
        this.gl.bindRenderbuffer(36161, rbuf);
        this.gl.renderbufferStorage(36161, 32854, width, height);
        this.gl.framebufferTexture2D(36160, 36064, 3553, tex, 0);
        this.gl.framebufferRenderbuffer(36160, 36096, 36161, rbuf);
        this.gl.bindTexture(3553, null);
        this.gl.bindRenderbuffer(36161, null);
        this.gl.bindFramebuffer(36160, null);
        return this.fbuf;
    }

    private WebGLTexture createTexture(String url) {
        final WebGLTexture tex = this.gl.createTexture();
        final ImageElement img = WebGLDemo.createImage();
        img.setSrc(url);
        WebGLDemo.hookOnLoad(img, new EventHandler(){

            @Override
            public void onEvent(NativeEvent e) {
                WebGLDemo.this.gl.bindTexture(3553, tex);
                WebGLDemo.this.gl.texImage2D(3553, 0, 6408, 6408, 5121, img);
                WebGLDemo.this.gl.texParameteri(3553, 10240, 9729);
                WebGLDemo.this.gl.texParameteri(3553, 10241, 9729);
                WebGLDemo.this.gl.texParameteri(3553, 10242, 33071);
                WebGLDemo.this.gl.texParameteri(3553, 10243, 33071);
                WebGLDemo.this.gl.bindTexture(3553, null);
            }
        });
        return tex;
    }

    private void initVertexBuffer() {
        this.buffer = this.gl.createBuffer();
        this.gl.bindBuffer(34962, this.buffer);
        this.gl.bufferData(34962, 80, 35044);
        float z = 0.0f;
        float[] positions = new float[]{-21.0f, -21.0f, z, 21.0f, -21.0f, z, -21.0f, 21.0f, z, 21.0f, 21.0f, z};
        this.gl.bufferSubData(34962, 0, (ArrayBufferView)ArrayUtils.createFloat32Array(positions));
        float[] texCoords = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.gl.bufferSubData(34962, 48, (ArrayBufferView)ArrayUtils.createFloat32Array(texCoords));
        int[] indices = new int[]{0, 1, 2, 3};
        this.indexBuffer = this.gl.createBuffer();
        this.gl.bindBuffer(34963, this.indexBuffer);
        this.gl.bufferData(34963, (ArrayBufferView)ArrayUtils.createInt32Array(indices), 35040);
    }

    private static interface EventHandler {
        public void onEvent(NativeEvent var1);
    }
}

