/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Clock;
import playn.core.GL20;
import playn.core.Game;
import playn.core.Platform;
import playn.core.QuadBatch;
import playn.core.Surface;
import playn.core.TriangleBatch;
import playn.core.UniformQuadBatch;
import playn.scene.RootLayer;
import react.SignalView;
import react.Slot;

public abstract class SceneGame
extends Game {
    private float cred;
    private float cgreen;
    private float cblue;
    private float calpha;
    public final QuadBatch defaultBatch;
    public final Surface viewSurf;
    public final RootLayer rootLayer;

    public SceneGame(Platform plat, int updateRate) {
        super(plat, updateRate);
        GL20 gl = plat.graphics().gl;
        gl.glDisable(2884);
        gl.glEnable(3042);
        gl.glBlendFunc(1, 771);
        this.defaultBatch = this.createDefaultBatch(gl);
        this.viewSurf = new Surface(plat.graphics(), plat.graphics().defaultRenderTarget, this.defaultBatch);
        this.rootLayer = new RootLayer();
        this.paint.connect((SignalView.Listener)new Slot<Clock>(){

            public void onEmit(Clock clock) {
                SceneGame.this.paintScene();
            }
        }).atPrio(this.scenePaintPrio());
    }

    public void setClearColor(float red, float green, float blue, float alpha) {
        this.cred = red;
        this.cgreen = green;
        this.cblue = blue;
        this.calpha = alpha;
    }

    public void setClearColor(int argb) {
        float red = (float)(argb >> 16 & 0xFF) / 255.0f;
        float green = (float)(argb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(argb >> 0 & 0xFF) / 255.0f;
        float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.setClearColor(red, green, blue, alpha);
    }

    protected void paintScene() {
        this.viewSurf.saveTx();
        this.viewSurf.begin();
        this.viewSurf.clear(this.cred, this.cgreen, this.cblue, this.calpha);
        try {
            this.rootLayer.paint(this.viewSurf);
        }
        finally {
            this.viewSurf.end();
            this.viewSurf.restoreTx();
        }
    }

    protected int scenePaintPrio() {
        return -1;
    }

    protected QuadBatch createDefaultBatch(GL20 gl) {
        try {
            if (UniformQuadBatch.isLikelyToPerform((GL20)gl)) {
                return new UniformQuadBatch(gl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TriangleBatch(gl);
    }
}

