/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Canvas;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.Texture;
import playn.core.Tile;
import playn.scene.ImageLayer;
import pythagoras.f.IDimension;
import react.RFuture;

public class CanvasLayer
extends ImageLayer {
    private final Graphics gfx;
    private Canvas canvas;

    public CanvasLayer(Graphics gfx, IDimension size) {
        this(gfx, size.width(), size.height());
    }

    public CanvasLayer(Graphics gfx, float width, float height) {
        this.gfx = gfx;
        this.resize(width, height);
    }

    public CanvasLayer(Graphics gfx, Canvas canvas) {
        this.gfx = gfx;
        this.canvas = canvas;
        super.setTile((Tile)canvas.image.createTexture(Texture.Config.DEFAULT));
    }

    public void resize(float width, float height) {
        if (this.canvas != null) {
            this.canvas.close();
        }
        this.canvas = this.gfx.createCanvas(width, height);
    }

    public Canvas begin() {
        return this.canvas;
    }

    public void end() {
        Texture tex = (Texture)this.tile();
        Image image = this.canvas.image;
        if (tex != null && tex.pixelWidth == image.pixelWidth() && tex.pixelHeight == image.pixelHeight()) {
            tex.update(image);
        } else {
            super.setTile((Tile)this.canvas.image.createTexture(Texture.Config.DEFAULT));
        }
    }

    @Override
    public ImageLayer setTile(Tile tile) {
        if (tile == null || tile instanceof Texture) {
            return super.setTile(tile);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ImageLayer setTile(RFuture<? extends Tile> tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float width() {
        return this.forceWidth < 0.0f ? this.canvas.width : this.forceWidth;
    }

    @Override
    public float height() {
        return this.forceHeight < 0.0f ? this.canvas.height : this.forceHeight;
    }

    @Override
    public void close() {
        super.close();
        if (this.canvas != null) {
            this.canvas.close();
            this.canvas = null;
        }
    }
}

