/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Platform;
import playn.core.Pointer;
import playn.scene.Layer;
import playn.scene.LayerUtil;
import pythagoras.f.Point;
import react.Slot;

public class Pointer
extends playn.core.Pointer {
    public Pointer(Platform plat, Layer root, boolean bubble) {
        super(plat);
        this.events.connect((Slot)new Dispatcher(root, bubble));
    }

    public static class Dispatcher
    extends Slot<Pointer.Event> {
        private final Layer root;
        private final boolean bubble;
        private final Point scratch = new Point();
        private Interaction currentIact;

        public Dispatcher(Layer root, boolean bubble) {
            this.root = root;
            this.bubble = bubble;
        }

        public void onEmit(Pointer.Event event) {
            Layer hitLayer;
            if (this.currentIact == null && event.kind.isStart && (hitLayer = LayerUtil.getHitLayer(this.root, this.scratch.set(event.x, event.y))) != null) {
                this.currentIact = new Interaction(hitLayer, this.bubble);
            }
            if (this.currentIact != null) {
                this.currentIact.dispatch(event);
            }
            if (event.kind.isEnd) {
                this.currentIact = null;
            }
        }
    }

    public static class Interaction
    extends playn.scene.Interaction<Pointer.Event> {
        Interaction(Layer hitLayer, boolean bubble) {
            super(hitLayer, bubble);
        }

        @Override
        protected Pointer.Event newCancelEvent(Pointer.Event source) {
            return source == null ? new Pointer.Event(0, 0.0, 0.0f, 0.0f, Pointer.Event.Kind.CANCEL, false) : new Pointer.Event(0, source.time, source.x, source.y, Pointer.Event.Kind.CANCEL, source.isTouch);
        }
    }

    public static abstract class Listener
    extends Slot<Object> {
        public void onStart(Interaction iact) {
        }

        public void onDrag(Interaction iact) {
        }

        public void onEnd(Interaction iact) {
        }

        public void onCancel(Interaction iact) {
        }

        public final void onEmit(Object event) {
            if (event instanceof Interaction) {
                Interaction iact = (Interaction)event;
                switch (((Pointer.Event)iact.event).kind) {
                    case START: {
                        this.onStart(iact);
                        break;
                    }
                    case DRAG: {
                        this.onDrag(iact);
                        break;
                    }
                    case END: {
                        this.onEnd(iact);
                        break;
                    }
                    case CANCEL: {
                        this.onCancel(iact);
                        break;
                    }
                }
            }
        }
    }
}

