/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Clock;
import playn.scene.GroupLayer;
import playn.scene.Layer;
import pythagoras.f.IPoint;
import pythagoras.f.Point;
import pythagoras.f.XY;
import pythagoras.util.NoninvertibleTransformException;
import react.Closeable;
import react.Signal;
import react.Slot;
import react.ValueView;

public class LayerUtil {
    public static Point layerToScreen(Layer layer, XY point, Point into) {
        return LayerUtil.layerToParent(layer, null, point, into);
    }

    public static Point layerToScreen(Layer layer, float x, float y) {
        Point into = new Point(x, y);
        return LayerUtil.layerToScreen(layer, (XY)into, into);
    }

    public static Point layerToParent(Layer layer, Layer parent, XY point, Point into) {
        into.set(point);
        while (layer != parent) {
            if (layer == null) {
                throw new IllegalArgumentException("Failed to find parent, perhaps you passed parent, layer instead of layer, parent?");
            }
            into.x -= layer.originX();
            into.y -= layer.originY();
            layer.transform().transform((IPoint)into, into);
            layer = layer.parent();
        }
        return into;
    }

    public static Point layerToParent(Layer layer, Layer parent, float x, float y) {
        Point into = new Point(x, y);
        return LayerUtil.layerToParent(layer, parent, (XY)into, into);
    }

    public static Point screenToLayer(Layer layer, XY point, Point into) {
        GroupLayer parent = layer.parent();
        XY cur = parent == null ? point : LayerUtil.screenToLayer((Layer)parent, point, into);
        return LayerUtil.parentToLayer(layer, cur, into);
    }

    public static Point screenToLayer(Layer layer, float x, float y) {
        Point into = new Point(x, y);
        return LayerUtil.screenToLayer(layer, (XY)into, into);
    }

    public static Point parentToLayer(Layer layer, XY point, Point into) {
        layer.transform().inverseTransform((IPoint)into.set(point), into);
        into.x += layer.originX();
        into.y += layer.originY();
        return into;
    }

    public static Point parentToLayer(Layer parent, Layer layer, XY point, Point into) {
        into.set(point);
        GroupLayer immediateParent = layer.parent();
        if (immediateParent != parent) {
            LayerUtil.parentToLayer(parent, immediateParent, (XY)into, into);
        }
        LayerUtil.parentToLayer(layer, (XY)into, into);
        return into;
    }

    public static Layer getHitLayer(Layer root, Point p) {
        root.transform().inverseTransform((IPoint)p, p);
        p.x += root.originX();
        p.y += root.originY();
        return root.hitTest(p);
    }

    public static boolean hitTest(Layer layer, XY pos) {
        return LayerUtil.hitTest(layer, pos.x(), pos.y());
    }

    public static boolean hitTest(Layer layer, float x, float y) {
        Point point = LayerUtil.screenToLayer(layer, x, y);
        return point.x() >= 0.0f && point.y() >= 0.0f && point.x() <= layer.width() && point.y() <= layer.height();
    }

    public static Layer layerUnderPoint(Layer root, float x, float y) {
        Point p = new Point(x, y);
        root.transform().inverseTransform((IPoint)p, p);
        p.x += root.originX();
        p.y += root.originY();
        return LayerUtil.layerUnderPoint(root, p);
    }

    public static int indexInParent(Layer layer) {
        GroupLayer parent = layer.parent();
        if (parent == null) {
            return -1;
        }
        for (int ii = parent.children() - 1; ii >= 0; --ii) {
            if (parent.childAt(ii) != layer) continue;
            return ii;
        }
        throw new AssertionError();
    }

    public static void bind(Layer layer, final Signal<Clock> paint, final Slot<Clock> onPaint) {
        layer.state.connectNotify((ValueView.Listener)new Slot<Layer.State>(){
            private Closeable _pcon = Closeable.Util.NOOP;

            public void onEmit(Layer.State state) {
                this._pcon = Closeable.Util.close((Closeable)this._pcon);
                if (state == Layer.State.ADDED) {
                    this._pcon = paint.connect(onPaint);
                }
            }
        });
    }

    public static void bind(Layer layer, final Signal<Clock> update, final Slot<Clock> onUpdate, final Signal<Clock> paint, final Slot<Clock> onPaint) {
        layer.state.connectNotify((ValueView.Listener)new Slot<Layer.State>(){
            private Closeable _ucon = Closeable.Util.NOOP;
            private Closeable _pcon = Closeable.Util.NOOP;

            public void onEmit(Layer.State state) {
                this._pcon = Closeable.Util.close((Closeable)this._pcon);
                this._ucon = Closeable.Util.close((Closeable)this._ucon);
                if (state == Layer.State.ADDED) {
                    this._ucon = update.connect(onUpdate);
                    this._pcon = paint.connect(onPaint);
                }
            }
        });
    }

    public static int graphDepth(Layer layer) {
        int depth = -1;
        while (layer != null) {
            layer = layer.parent();
            ++depth;
        }
        return depth;
    }

    protected static Layer layerUnderPoint(Layer layer, Point pt) {
        float x = pt.x;
        float y = pt.y;
        if (layer instanceof GroupLayer) {
            GroupLayer gl = (GroupLayer)layer;
            for (int ii = gl.children() - 1; ii >= 0; --ii) {
                Layer child = gl.childAt(ii);
                if (!child.visible()) continue;
                try {
                    child.transform().inverseTransform((IPoint)pt.set(x, y), pt);
                    pt.x += child.originX();
                    pt.y += child.originY();
                    Layer l = LayerUtil.layerUnderPoint(child, pt);
                    if (l != null) {
                        return l;
                    }
                    continue;
                }
                catch (NoninvertibleTransformException nte) {
                    // empty catch block
                }
            }
        }
        if (x >= 0.0f && x < layer.width() && y >= 0.0f && y < layer.height()) {
            return layer;
        }
        return null;
    }
}

