/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Event;
import playn.scene.Layer;
import playn.scene.LayerUtil;
import pythagoras.f.Point;
import pythagoras.f.XY;

public abstract class Interaction<E extends Event.XY>
implements XY {
    private final boolean bubble;
    private boolean canceled;
    private Layer dispatchLayer;
    private Layer capturingLayer;
    public final Layer hitLayer;
    public final Point local = new Point();
    public E event;

    public float x() {
        return ((Event.XY)this.event).x;
    }

    public float y() {
        return ((Event.XY)this.event).y;
    }

    public boolean captured() {
        return this.capturingLayer != null;
    }

    public void capture() {
        assert (this.dispatchLayer != null);
        if (this.canceled) {
            throw new IllegalStateException("Cannot capture canceled interaction.");
        }
        if (this.capturingLayer != this.dispatchLayer && this.captured()) {
            throw new IllegalStateException("Interaction already captured by " + this.capturingLayer);
        }
        this.capturingLayer = this.dispatchLayer;
        this.notifyCancel(this.capturingLayer, this.event);
    }

    public void cancel() {
        if (!this.canceled) {
            this.notifyCancel(null, this.event);
            this.canceled = true;
        }
    }

    public Interaction(Layer hitLayer, boolean bubble) {
        assert (hitLayer != null);
        this.hitLayer = hitLayer;
        this.bubble = bubble;
    }

    void dispatch(E event) {
        if (this.canceled) {
            return;
        }
        assert (event != null);
        LayerUtil.screenToLayer(this.hitLayer, (XY)this.local.set(((Event.XY)event).x, ((Event.XY)event).y), this.local);
        this.event = event;
        try {
            if (this.bubble) {
                for (Layer target = this.hitLayer; target != null; target = target.parent()) {
                    if (this.capturingLayer != null && target != this.capturingLayer || !target.hasEventListeners()) continue;
                    this.dispatch(target);
                }
            } else if (this.hitLayer.hasEventListeners()) {
                this.dispatch(this.hitLayer);
            }
        }
        finally {
            this.event = null;
        }
        this.local.set(0.0f, 0.0f);
    }

    void dispatch(Layer layer) {
        this.dispatchLayer = layer;
        try {
            layer.events().emit((Object)this);
        }
        finally {
            this.dispatchLayer = null;
        }
    }

    protected abstract E newCancelEvent(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancel(Layer except, E source) {
        E oldEvent = this.event;
        this.event = this.newCancelEvent(source);
        try {
            if (this.bubble) {
                for (Layer target = this.hitLayer; target != null; target = target.parent()) {
                    if (target == except || !target.hasEventListeners()) continue;
                    this.dispatch(target);
                }
            } else if (this.hitLayer != except && this.hitLayer.hasEventListeners()) {
                this.dispatch(this.hitLayer);
            }
        }
        finally {
            this.event = oldEvent;
        }
    }
}

