/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Surface;
import playn.core.Tile;
import playn.core.TileSource;
import playn.scene.Layer;
import pythagoras.f.IDimension;
import pythagoras.f.Rectangle;
import react.RFuture;
import react.Slot;

public class ImageLayer
extends Layer {
    private Tile tile;
    public float forceWidth = -1.0f;
    public float forceHeight = -1.0f;
    public Rectangle region;

    public ImageLayer(Tile tile) {
        this.setTile(tile);
    }

    public ImageLayer(TileSource source) {
        this.setSource(source);
    }

    public ImageLayer() {
    }

    public Tile tile() {
        return this.tile;
    }

    public ImageLayer setTile(Tile tile) {
        if (this.tile != tile) {
            if (this.tile != null) {
                this.tile.texture().release();
            }
            this.tile = tile;
            this.checkOrigin();
            if (tile != null) {
                tile.texture().reference();
            }
        }
        return this;
    }

    public ImageLayer setSource(TileSource source) {
        if (source.isLoaded()) {
            this.setTile(source.tile());
        } else {
            source.tileAsync().onSuccess((Slot)new Slot<Tile>(){

                public void onEmit(Tile tile) {
                    ImageLayer.this.setTile(tile);
                }
            });
        }
        return this;
    }

    public ImageLayer setTile(RFuture<? extends Tile> tile) {
        tile.onSuccess((Slot)new Slot<Tile>(){

            public void onEmit(Tile tile) {
                ImageLayer.this.setTile(tile);
            }
        });
        return this;
    }

    public ImageLayer setSize(float width, float height) {
        this.forceWidth = width;
        this.forceHeight = height;
        this.checkOrigin();
        return this;
    }

    public ImageLayer setSize(IDimension size) {
        return this.setSize(size.width(), size.height());
    }

    public ImageLayer setRegion(Rectangle region) {
        this.region = region;
        this.checkOrigin();
        return this;
    }

    @Override
    public float width() {
        if (this.forceWidth >= 0.0f) {
            return this.forceWidth;
        }
        if (this.region != null) {
            return this.region.width;
        }
        return this.tile == null ? 0.0f : this.tile.width();
    }

    @Override
    public float height() {
        if (this.forceHeight >= 0.0f) {
            return this.forceHeight;
        }
        if (this.region != null) {
            return this.region.height;
        }
        return this.tile == null ? 0.0f : this.tile.height();
    }

    @Override
    public void close() {
        super.close();
        this.setTile((Tile)null);
    }

    @Override
    protected void paintImpl(Surface surf) {
        if (this.tile != null) {
            float dwidth = this.width();
            float dheight = this.height();
            if (this.region == null) {
                surf.draw(this.tile, 0.0f, 0.0f, dwidth, dheight);
            } else {
                surf.draw(this.tile, 0.0f, 0.0f, dwidth, dheight, this.region.x, this.region.y, this.region.width, this.region.height);
            }
        }
    }

    protected void finalize() {
        this.setTile((Tile)null);
    }
}

