/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGBitmapInfo;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGImageAlphaInfo;
import org.robovm.apple.coregraphics.CGInterpolationQuality;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIImage;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.IntPtr;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Pattern;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.Texture;
import playn.robovm.OpenGLES;
import playn.robovm.RoboBitmapTransformer;
import playn.robovm.RoboGraphics;
import playn.robovm.RoboPattern;
import playn.robovm.RoboPlatform;

public class RoboImage
extends ImageImpl {
    private CGImage image;

    public RoboImage(Graphics gfx, Scale scale, CGImage img, String source) {
        super(gfx, scale, (int)img.getWidth(), (int)img.getHeight(), source, (Object)img);
    }

    public RoboImage(RoboPlatform plat, boolean async, int preWidth, int preHeight, String source) {
        super((Platform)plat, async, Scale.ONE, preWidth, preHeight, source);
    }

    public CGImage cgImage() {
        return this.image;
    }

    public UIImage toUIImage() {
        return new UIImage(this.cgImage());
    }

    public Pattern createPattern(boolean repeatX, boolean repeatY) {
        if (this.image == null) {
            throw new IllegalStateException("Can't create pattern from un-ready image.");
        }
        return new RoboPattern(UIColor.fromPatternImage((UIImage)this.toUIImage()).getCGColor(), repeatX, repeatY);
    }

    public void getRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        int bytesPerRow = 4 * width;
        CGBitmapContext context = CGBitmapContext.create((long)width, (long)height, (long)8L, (long)bytesPerRow, (CGColorSpace)CGColorSpace.createDeviceRGB(), (CGBitmapInfo)new CGBitmapInfo(CGImageAlphaInfo.PremultipliedFirst.value()));
        context.setInterpolationQuality(CGInterpolationQuality.None);
        this.draw(context, 0.0f, 0.0f, width, height, startX, startY, width, height);
    }

    public void setRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        throw new UnsupportedOperationException("TODO!");
    }

    public Image transform(Image.BitmapTransformer xform) {
        UIImage ximage = new UIImage(((RoboBitmapTransformer)xform).transform(this.cgImage()));
        return new RoboImage(this.gfx, this.scale, ximage.getCGImage(), this.source);
    }

    public void draw(Object ctx, float x, float y, float width, float height) {
        CGBitmapContext bctx = (CGBitmapContext)ctx;
        bctx.saveGState();
        bctx.translateCTM((double)x, (double)(y += height));
        bctx.scaleCTM(1.0, -1.0);
        bctx.drawImage(new CGRect(0.0, 0.0, (double)width, (double)height), this.cgImage());
        bctx.restoreGState();
    }

    public void draw(Object ctx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        sx *= this.scale.factor;
        sy *= this.scale.factor;
        sw *= this.scale.factor;
        sh *= this.scale.factor;
        CGImage image = this.cgImage();
        CGBitmapContext bctx = (CGBitmapContext)ctx;
        float iw = image.getWidth();
        float ih = image.getHeight();
        float scaleX = dw / sw;
        float scaleY = dh / sh;
        bctx.saveGState();
        bctx.translateCTM((double)dx, (double)(dy + dh));
        bctx.scaleCTM(1.0, -1.0);
        bctx.clipToRect(new CGRect(0.0, 0.0, (double)dw, (double)dh));
        bctx.translateCTM((double)(-sx * scaleX), (double)(-(ih - (sy + sh)) * scaleY));
        bctx.drawImage(new CGRect(0.0, 0.0, (double)(iw * scaleX), (double)(ih * scaleY)), image);
        bctx.restoreGState();
    }

    public String toString() {
        return "Image[src=" + this.source + ", cgimg=" + this.image + "]";
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    protected RoboImage(Graphics gfx, Scale scale, int pixelWidth, int pixelHeight, String source) {
        super(gfx, scale, pixelWidth, pixelHeight, source, null);
    }

    protected void finalize() {
        this.dispose();
    }

    protected void upload(Graphics gfx, Texture tex) {
        int width = this.pixelWidth;
        int height = this.pixelHeight;
        if (width == 0 || height == 0) {
            ((RoboGraphics)gfx).plat.log().info("Ignoring texture update for empty image (" + width + "x" + height + ").");
            return;
        }
        CGBitmapContext bctx = RoboGraphics.createCGBitmap(width, height);
        CGRect rect = new CGRect(0.0, 0.0, (double)width, (double)height);
        bctx.clearRect(rect);
        bctx.drawImage(rect, this.image);
        this.upload(gfx, tex.id, width, height, bctx.getData());
        bctx.dispose();
    }

    protected void upload(Graphics gfx, int tex, int width, int height, IntPtr data) {
        gfx.gl.glBindTexture(3553, tex);
        gfx.gl.glPixelStorei(3317, 1);
        OpenGLES.glTexImage2Dp(3553, 0, 6408, width, height, 0, 6408, 5121, data);
    }

    protected void upload(Graphics gfx, int tex, int width, int height, @Pointer long data) {
        gfx.gl.glBindTexture(3553, tex);
        gfx.gl.glPixelStorei(3317, 1);
        OpenGLES.glTexImage2Dp(3553, 0, 6408, width, height, 0, 6408, 5121, data);
    }

    protected void setBitmap(Object bitmap) {
        this.image = (CGImage)bitmap;
    }

    protected Object createErrorBitmap(int pixelWidth, int pixelHeight) {
        return RoboGraphics.createCGBitmap(pixelWidth, pixelHeight).toImage();
    }
}

