/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.glkit.GLKView;
import org.robovm.apple.glkit.GLKViewController;
import org.robovm.apple.glkit.GLKViewControllerDelegate;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.opengles.EAGLRenderingAPI;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.annotation.Method;
import playn.robovm.RoboInput;
import playn.robovm.RoboOrientEvent;
import playn.robovm.RoboPlatform;

public class RoboViewController
extends GLKViewController {
    private final GLKView view;
    public final RoboPlatform plat;

    public RoboViewController(CGRect bounds, RoboPlatform.Config config) {
        EAGLContext ctx = new EAGLContext(EAGLRenderingAPI.OpenGLES2);
        EAGLContext.setCurrentContext((EAGLContext)ctx);
        this.plat = new RoboPlatform(config, bounds);
        this.view = new View(bounds, ctx, this.plat.input());
        this.view.setMultipleTouchEnabled(true);
        this.view.setDrawableColorFormat(this.plat.config.glBufferFormat);
        this.setView((UIView)this.view);
        this.setDelegate(new Delegate(this.view, this.plat));
        this.setPreferredFramesPerSecond(config.targetFPS);
        this.addStrongRef((Object)this.plat);
    }

    public void viewWillAppear(boolean animated) {
        super.viewWillAppear(animated);
        this.view.bindDrawable();
        this.plat.graphics().viewDidInit(this.getView().getBounds());
    }

    public void viewDidAppear(boolean animated) {
        super.viewDidAppear(animated);
        this.plat.dispatchEvent(this.plat.input().focus, true);
    }

    public void viewWillDisappear(boolean animated) {
        super.viewWillDisappear(animated);
        this.plat.dispatchEvent(this.plat.input().focus, false);
    }

    public void viewDidDisappear(boolean animated) {
        super.viewDidDisappear(animated);
        EAGLContext.setCurrentContext(null);
    }

    public void willRotate(UIInterfaceOrientation toOrient, double duration) {
        super.willRotate(toOrient, duration);
        this.plat.orient.emit((Object)new RoboOrientEvent.WillRotate(toOrient, duration));
    }

    public void didRotate(UIInterfaceOrientation fromOrient) {
        super.didRotate(fromOrient);
        this.plat.graphics().boundsChanged(this.getView().getBounds());
        this.plat.orient.emit((Object)new RoboOrientEvent.DidRotate(fromOrient));
    }

    public UIInterfaceOrientationMask getSupportedInterfaceOrientations() {
        return this.plat.config.orients;
    }

    public boolean shouldAutorotate() {
        return true;
    }

    protected void doDispose() {
        this.plat.willTerminate();
        this.removeStrongRef((Object)this.plat);
        super.doDispose();
    }

    private static class View
    extends GLKView {
        private final RoboInput input;

        View(CGRect bounds, EAGLContext ctx, RoboInput input) {
            super(bounds, ctx);
            this.input = input;
        }

        @Method(selector="touchesBegan:withEvent:")
        public void touchesBegan(NSSet<UITouch> touches, UIEvent event) {
            this.input.onTouchesBegan(touches, event);
        }

        @Method(selector="touchesCancelled:withEvent:")
        public void touchesCancelled(NSSet<UITouch> touches, UIEvent event) {
            this.input.onTouchesCancelled(touches, event);
        }

        @Method(selector="touchesEnded:withEvent:")
        public void touchesEnded(NSSet<UITouch> touches, UIEvent event) {
            this.input.onTouchesEnded(touches, event);
        }

        @Method(selector="touchesMoved:withEvent:")
        public void touchesMoved(NSSet<UITouch> touches, UIEvent event) {
            this.input.onTouchesMoved(touches, event);
        }
    }

    private static class Delegate
    extends NSObject
    implements GLKViewControllerDelegate {
        private final RoboPlatform plat;
        private final GLKView view;

        Delegate(GLKView view, RoboPlatform plat) {
            this.view = view;
            this.plat = plat;
        }

        public void update(GLKViewController viewController) {
            this.plat.processFrame();
        }

        public void willPause(GLKViewController viewController, boolean paused) {
            if (paused) {
                this.plat.didEnterBackground();
            } else {
                this.view.bindDrawable();
                this.plat.willEnterForeground();
            }
        }
    }
}

