/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.glkit.GLKView;
import org.robovm.apple.glkit.GLKViewController;
import org.robovm.apple.glkit.GLKViewControllerDelegate;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.opengles.EAGLRenderingAPI;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.BindSelector;
import org.robovm.objc.annotation.Method;
import org.robovm.rt.bro.annotation.Callback;
import playn.robovm.RoboOrientEvent;
import playn.robovm.RoboPlatform;

public class RoboViewController
extends GLKViewController
implements GLKViewControllerDelegate {
    private final GLKView view;
    public final RoboPlatform plat;

    public RoboViewController(CGRect bounds, RoboPlatform.Config config) {
        EAGLContext ctx = new EAGLContext(EAGLRenderingAPI.OpenGLES2);
        EAGLContext.setCurrentContext((EAGLContext)ctx);
        this.plat = new RoboPlatform(config, bounds);
        this.view = new GLKView(bounds, ctx){

            @Method(selector="touchesBegan:withEvent:")
            public void touchesBegan(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.plat.input().onTouchesBegan(touches, event);
            }

            @Method(selector="touchesCancelled:withEvent:")
            public void touchesCancelled(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.plat.input().onTouchesCancelled(touches, event);
            }

            @Method(selector="touchesEnded:withEvent:")
            public void touchesEnded(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.plat.input().onTouchesEnded(touches, event);
            }

            @Method(selector="touchesMoved:withEvent:")
            public void touchesMoved(NSSet<UITouch> touches, UIEvent event) {
                RoboViewController.this.plat.input().onTouchesMoved(touches, event);
            }
        };
        this.view.setMultipleTouchEnabled(true);
        this.view.setDrawableColorFormat(this.plat.config.glBufferFormat);
        this.setView((UIView)this.view);
        this.setDelegate(this);
        this.setPreferredFramesPerSecond(config.targetFPS);
        this.addStrongRef((Object)this.plat);
    }

    public void update(GLKViewController self) {
        this.plat.processFrame();
    }

    public void willPause(GLKViewController self, boolean paused) {
        if (paused) {
            this.plat.didEnterBackground();
        } else {
            this.view.bindDrawable();
            this.plat.willEnterForeground();
        }
    }

    public void viewWillAppear(boolean animated) {
        super.viewWillAppear(animated);
        this.view.bindDrawable();
        this.plat.graphics().viewDidInit(this.getView().getBounds());
    }

    public void viewDidAppear(boolean animated) {
        super.viewDidAppear(animated);
        this.plat.dispatchEvent(this.plat.input().focus, true);
    }

    public void viewWillDisappear(boolean animated) {
        super.viewWillDisappear(animated);
        this.plat.dispatchEvent(this.plat.input().focus, false);
    }

    public void viewDidDisappear(boolean animated) {
        super.viewDidDisappear(animated);
        EAGLContext.setCurrentContext(null);
    }

    public void willRotate(UIInterfaceOrientation toOrient, double duration) {
        super.willRotate(toOrient, duration);
        this.plat.orient.emit((Object)new RoboOrientEvent.WillRotate(toOrient, duration));
    }

    public void didRotate(UIInterfaceOrientation fromOrient) {
        super.didRotate(fromOrient);
        this.plat.graphics().boundsChanged(this.getView().getBounds());
        this.plat.orient.emit((Object)new RoboOrientEvent.DidRotate(fromOrient));
    }

    public UIInterfaceOrientationMask getSupportedInterfaceOrientations() {
        return this.plat.config.orients;
    }

    public boolean shouldAutorotate() {
        return true;
    }

    public boolean shouldAutorotateToInterfaceOrientation(UIInterfaceOrientation orientation) {
        return true;
    }

    protected void doDispose() {
        this.plat.willTerminate();
        this.removeStrongRef((Object)this.plat);
        super.doDispose();
    }

    @Callback
    @BindSelector(value="shouldAutorotateToInterfaceOrientation:")
    private static boolean shouldAutorotateToInterfaceOrientation(RoboViewController self, Selector sel, UIInterfaceOrientation orientation) {
        return self.shouldAutorotateToInterfaceOrientation(orientation);
    }
}

