/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSThread;
import org.robovm.apple.foundation.NSTimer;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.glkit.GLKViewDrawableColorFormat;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.apple.uikit.UIApplication;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UIViewController;
import org.robovm.apple.uikit.UIWindow;
import org.robovm.objc.block.VoidBlock1;
import playn.core.Exec;
import playn.core.Json;
import playn.core.Log;
import playn.core.Net;
import playn.core.Platform;
import playn.core.Storage;
import playn.core.json.JsonImpl;
import playn.robovm.RoboAssets;
import playn.robovm.RoboAudio;
import playn.robovm.RoboGraphics;
import playn.robovm.RoboInput;
import playn.robovm.RoboLog;
import playn.robovm.RoboNet;
import playn.robovm.RoboOrientEvent;
import playn.robovm.RoboStorage;
import playn.robovm.RoboViewController;
import react.Signal;

public class RoboPlatform
extends Platform {
    public Signal<RoboOrientEvent> orient = Signal.create();
    final int osVersion = this.getOSVersion();
    final Config config;
    private boolean paused = false;
    private final long gameStart = System.nanoTime();
    private final ExecutorService pool = Executors.newFixedThreadPool(3);
    private final RoboLog log = new RoboLog();
    private final Json json = new JsonImpl();
    private final Exec exec = new Exec.Default(this){

        public boolean isMainThread() {
            return NSThread.getCurrentThread().isMainThread();
        }

        public void invokeLater(Runnable action) {
            if (RoboPlatform.this.paused) {
                NSOperationQueue.getMainQueue().addOperation(action);
            } else {
                super.invokeLater(action);
            }
        }

        public boolean isAsyncSupported() {
            return true;
        }

        public void invokeAsync(Runnable action) {
            RoboPlatform.this.pool.execute(action);
        }
    };
    private RoboAudio audio;
    private final RoboAssets assets;
    private final RoboGraphics graphics;
    private final RoboInput input;
    private final RoboNet net;
    private final RoboStorage storage;

    public static RoboPlatform create(UIWindow window, Config config) {
        RoboViewController ctrl = new RoboViewController(window.getBounds(), config);
        window.setRootViewController((UIViewController)ctrl);
        return ctrl.plat;
    }

    protected RoboPlatform(Config config, CGRect initBounds) {
        this.config = config;
        this.assets = new RoboAssets(this);
        this.graphics = new RoboGraphics(this, config, initBounds);
        this.input = new RoboInput(this);
        this.net = new RoboNet(this);
        this.storage = new RoboStorage(this);
    }

    public Platform.Type type() {
        return Platform.Type.IOS;
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public int tick() {
        return (int)((System.nanoTime() - this.gameStart) / 1000000L);
    }

    public void openURL(String url) {
        if (!UIApplication.getSharedApplication().openURL(new NSURL(url))) {
            this.log().warn("Failed to open URL: " + url);
        }
    }

    public RoboAssets assets() {
        return this.assets;
    }

    public RoboAudio audio() {
        if (this.audio == null) {
            this.audio = new RoboAudio(this, this.config.openALSources);
        }
        return this.audio;
    }

    public Exec exec() {
        return this.exec;
    }

    public Json json() {
        return this.json;
    }

    public Log log() {
        return this.log;
    }

    public Net net() {
        return this.net;
    }

    public RoboGraphics graphics() {
        return this.graphics;
    }

    public RoboInput input() {
        return this.input;
    }

    public Storage storage() {
        return this.storage;
    }

    void processFrame() {
        this.emitFrame();
    }

    void willEnterForeground() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.exec.invokeLater(new Runnable(){

            @Override
            public void run() {
                RoboPlatform.this.dispatchEvent(RoboPlatform.this.lifecycle, Platform.Lifecycle.RESUME);
            }
        });
    }

    void didEnterBackground() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.PAUSE);
    }

    void willTerminate() {
        new NSTimer((double)this.config.timeForTermination, (VoidBlock1)new VoidBlock1<NSTimer>(){

            public void invoke(NSTimer timer) {
                EAGLContext.setCurrentContext(null);
                if (RoboPlatform.this.audio != null) {
                    RoboPlatform.this.audio.terminate();
                }
            }
        }, null, false);
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.EXIT);
    }

    private int getOSVersion() {
        String systemVersion = UIDevice.getCurrentDevice().getSystemVersion();
        int version = Integer.parseInt(systemVersion.split("\\.")[0]);
        return version;
    }

    public static class Config {
        public UIInterfaceOrientationMask orients = UIInterfaceOrientationMask.Portrait;
        public boolean iPadLikePhone = false;
        public int frameInterval = 1;
        public boolean interpolateCanvasDrawing = true;
        public int openALSources = 24;
        public float timeForTermination = 0.5f;
        public GLKViewDrawableColorFormat glBufferFormat = GLKViewDrawableColorFormat.RGBA8888;
        public int targetFPS = 60;
        public String storageFileName = "playn.db";
    }
}

