/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGGradient;
import org.robovm.apple.coregraphics.CGGradientDrawingOptions;
import org.robovm.apple.coregraphics.CGPoint;
import playn.core.Gradient;
import playn.robovm.RoboGraphics;

public abstract class RoboGradient
extends Gradient {
    private static final CGGradientDrawingOptions gdOptions = new CGGradientDrawingOptions(CGGradientDrawingOptions.BeforeStartLocation.value() | CGGradientDrawingOptions.AfterEndLocation.value());
    final CGGradient cgGradient;

    abstract void fill(CGBitmapContext var1);

    protected RoboGradient(Gradient.Config cfg) {
        float[] comps = new float[cfg.colors.length * 4];
        int cc = 0;
        for (int color : cfg.colors) {
            comps[cc++] = (float)(color >> 16 & 0xFF) / 255.0f;
            comps[cc++] = (float)(color >> 8 & 0xFF) / 255.0f;
            comps[cc++] = (float)(color >> 0 & 0xFF) / 255.0f;
            comps[cc++] = (float)(color >> 24 & 0xFF) / 255.0f;
        }
        this.cgGradient = CGGradient.create((CGColorSpace)RoboGraphics.colorSpace, (float[])comps, (float[])cfg.positions);
    }

    protected void finalize() {
        this.cgGradient.dispose();
    }

    public static class Radial
    extends RoboGradient {
        final CGPoint center;
        final float r;

        public Radial(Gradient.Radial cfg) {
            super((Gradient.Config)cfg);
            this.center = new CGPoint((double)cfg.x, (double)cfg.y);
            this.r = cfg.r;
        }

        @Override
        void fill(CGBitmapContext bctx) {
            bctx.drawRadialGradient(this.cgGradient, this.center, 0.0, this.center, (double)this.r, gdOptions);
        }
    }

    public static class Linear
    extends RoboGradient {
        final CGPoint start;
        final CGPoint end;

        public Linear(Gradient.Linear cfg) {
            super((Gradient.Config)cfg);
            this.start = new CGPoint((double)cfg.x0, (double)cfg.y0);
            this.end = new CGPoint((double)cfg.x1, (double)cfg.y1);
        }

        @Override
        void fill(CGBitmapContext bctx) {
            bctx.drawLinearGradient(this.cgGradient, this.start, this.end, gdOptions);
        }
    }
}

