/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGBlendMode;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGLineCap;
import org.robovm.apple.coregraphics.CGLineJoin;
import org.robovm.apple.coregraphics.CGMutablePath;
import org.robovm.apple.coregraphics.CGPath;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGTextEncoding;
import org.robovm.apple.coretext.CTFont;
import playn.core.Canvas;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.Scale;
import playn.core.TextLayout;
import playn.robovm.RoboCanvasImage;
import playn.robovm.RoboCanvasState;
import playn.robovm.RoboFont;
import playn.robovm.RoboGradient;
import playn.robovm.RoboGraphics;
import playn.robovm.RoboImage;
import playn.robovm.RoboPath;
import playn.robovm.RoboPattern;
import playn.robovm.RoboTextLayout;

public class RoboCanvas
extends Canvas {
    private float strokeWidth = 1.0f;
    private int strokeColor = -16777216;
    private int fillColor = -16777216;
    private CGBitmapContext bctx;
    private LinkedList<RoboCanvasState> states = new LinkedList();
    private static Map<Canvas.Composite, CGBlendMode> compToBlend = new HashMap<Canvas.Composite, CGBlendMode>();
    private static Map<Canvas.LineCap, CGLineCap> decodeCap;
    private static Map<Canvas.LineJoin, CGLineJoin> decodeJoin;

    public RoboCanvas(Graphics gfx, RoboCanvasImage image) {
        super(gfx, (Image)image);
        if (this.width <= 0.0f || this.height <= 0.0f) {
            throw new IllegalArgumentException("Invalid size " + this.width + "x" + this.height);
        }
        this.states.addFirst(new RoboCanvasState());
        this.bctx = image.bctx;
        this.bctx.clearRect(new CGRect(0.0, 0.0, (double)this.texWidth(), (double)this.texHeight()));
        Scale scale = image.scale();
        this.bctx.translateCTM(0.0, (double)scale.scaled(this.height));
        this.bctx.scaleCTM((double)scale.factor, (double)(-scale.factor));
    }

    public int texWidth() {
        return this.image.pixelWidth();
    }

    public int texHeight() {
        return this.image.pixelHeight();
    }

    public CGImage cgimage() {
        return this.bctx.toImage();
    }

    public Canvas clear() {
        this.bctx.clearRect(new CGRect(0.0, 0.0, (double)this.texWidth(), (double)this.texHeight()));
        this.isDirty = true;
        return this;
    }

    public Canvas clearRect(float x, float y, float width, float height) {
        this.bctx.clearRect(new CGRect((double)x, (double)y, (double)width, (double)height));
        this.isDirty = true;
        return this;
    }

    public Canvas clip(Path clipPath) {
        this.bctx.addPath((CGPath)((RoboPath)clipPath).cgPath);
        this.bctx.clip();
        return this;
    }

    public Canvas clipRect(float x, float y, float width, float height) {
        this.bctx.clipToRect(new CGRect((double)x, (double)y, (double)width, (double)height));
        return this;
    }

    public void close() {
        ((RoboCanvasImage)this.image).dispose();
    }

    public Canvas drawLine(float x0, float y0, float x1, float y1) {
        this.bctx.beginPath();
        this.bctx.moveToPoint((double)x0, (double)y0);
        this.bctx.addLineToPoint((double)x1, (double)y1);
        this.bctx.strokePath();
        this.isDirty = true;
        return this;
    }

    public Canvas drawPoint(float x, float y) {
        this.save();
        this.setStrokeWidth(0.5f);
        this.strokeRect(x + 0.25f, y + 0.25f, 0.5f, 0.5f);
        this.restore();
        return this;
    }

    public Canvas drawArc(float cx, float cy, float r, float startAngle, float arcAngle) {
        int cw = arcAngle > 0.0f ? 1 : 0;
        this.bctx.beginPath();
        this.bctx.addArc((double)cx, (double)cy, (double)r, (double)(-startAngle), (double)(-(startAngle + arcAngle)), cw);
        this.bctx.strokePath();
        this.isDirty = true;
        return this;
    }

    public Canvas drawText(String text, float x, float y) {
        CTFont font = RoboFont.resolveFont(null);
        this.bctx.saveGState();
        this.bctx.translateCTM((double)x, (double)y + font.getDescent());
        this.bctx.scaleCTM(1.0, -1.0);
        this.bctx.selectFont(font.getPostScriptName(), font.getSize(), CGTextEncoding.MacRoman);
        this.bctx.showTextAtPoint(0.0, 0.0, text);
        this.bctx.restoreGState();
        this.isDirty = true;
        return this;
    }

    public Canvas fillCircle(float x, float y, float radius) {
        RoboGradient gradient = this.currentState().gradient;
        if (gradient == null) {
            this.bctx.fillEllipseInRect(new CGRect((double)(x - radius), (double)(y - radius), (double)(2.0f * radius), (double)(2.0f * radius)));
        } else {
            CGMutablePath cgPath = CGMutablePath.createMutable();
            cgPath.addArc(null, (double)x, (double)y, (double)radius, 0.0, Math.PI * 2, false);
            this.bctx.addPath((CGPath)cgPath);
            this.bctx.clip();
            gradient.fill(this.bctx);
        }
        this.isDirty = true;
        return this;
    }

    public Canvas fillPath(Path path) {
        this.bctx.addPath((CGPath)((RoboPath)path).cgPath);
        RoboGradient gradient = this.currentState().gradient;
        if (gradient == null) {
            this.bctx.fillPath();
        } else {
            this.bctx.clip();
            gradient.fill(this.bctx);
        }
        this.isDirty = true;
        return this;
    }

    public Canvas fillRect(float x, float y, float width, float height) {
        RoboGradient gradient = this.currentState().gradient;
        if (gradient == null) {
            this.bctx.fillRect(new CGRect((double)x, (double)y, (double)width, (double)height));
        } else {
            this.bctx.saveGState();
            this.bctx.clipToRect(new CGRect((double)x, (double)y, (double)width, (double)height));
            gradient.fill(this.bctx);
            this.bctx.restoreGState();
        }
        this.isDirty = true;
        return this;
    }

    public Canvas fillRoundRect(float x, float y, float width, float height, float radius) {
        this.addRoundRectPath(x, y, width, height, radius);
        RoboGradient gradient = this.currentState().gradient;
        if (gradient == null) {
            this.bctx.fillPath();
        } else {
            this.bctx.clip();
            gradient.fill(this.bctx);
        }
        this.isDirty = true;
        return this;
    }

    public Canvas fillText(TextLayout layout, float x, float y) {
        RoboGradient gradient = this.currentState().gradient;
        RoboTextLayout ilayout = (RoboTextLayout)layout;
        if (gradient == null) {
            ilayout.fill(this.bctx, x, y, this.fillColor);
        } else {
            CGBitmapContext maskContext = RoboGraphics.createCGBitmap(this.texWidth(), this.texHeight());
            maskContext.clearRect(new CGRect(0.0, 0.0, (double)this.texWidth(), (double)this.texHeight()));
            float scale = this.image.scale().factor;
            maskContext.scaleCTM((double)scale, (double)scale);
            RoboCanvas.setFillColor(maskContext, -1);
            ilayout.fill(maskContext, 0.0f, 0.0f, this.fillColor);
            this.bctx.saveGState();
            this.bctx.clipToMask(new CGRect((double)x, (double)y, (double)this.width, (double)this.height), maskContext.toImage());
            gradient.fill(this.bctx);
            this.bctx.restoreGState();
            maskContext.dispose();
        }
        this.isDirty = true;
        return this;
    }

    public Canvas restore() {
        this.states.removeFirst();
        this.bctx.restoreGState();
        return this;
    }

    public Canvas rotate(float radians) {
        this.bctx.rotateCTM((double)radians);
        return this;
    }

    public Canvas save() {
        this.states.addFirst(new RoboCanvasState(this.currentState()));
        this.bctx.saveGState();
        return this;
    }

    public Canvas scale(float x, float y) {
        this.bctx.scaleCTM((double)x, (double)y);
        return this;
    }

    public Canvas setAlpha(float alpha) {
        this.bctx.setAlpha((double)alpha);
        return this;
    }

    public Canvas setCompositeOperation(Canvas.Composite composite) {
        this.bctx.setBlendMode(compToBlend.get(composite));
        return this;
    }

    public Canvas setFillColor(int color) {
        this.fillColor = color;
        this.currentState().gradient = null;
        RoboCanvas.setFillColor(this.bctx, color);
        return this;
    }

    public Canvas setFillGradient(Gradient gradient) {
        this.currentState().gradient = (RoboGradient)gradient;
        return this;
    }

    public Canvas setFillPattern(Pattern pattern) {
        this.currentState().gradient = null;
        this.bctx.setFillColor(((RoboPattern)pattern).colorWithPattern);
        return this;
    }

    public Canvas setLineCap(Canvas.LineCap cap) {
        this.bctx.setLineCap(decodeCap.get(cap));
        return this;
    }

    public Canvas setLineJoin(Canvas.LineJoin join) {
        this.bctx.setLineJoin(decodeJoin.get(join));
        return this;
    }

    public Canvas setMiterLimit(float miter) {
        this.bctx.setMiterLimit((double)miter);
        return this;
    }

    public Canvas setStrokeColor(int color) {
        this.strokeColor = color;
        RoboCanvas.setStrokeColor(this.bctx, color);
        return this;
    }

    public Canvas setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.bctx.setLineWidth((double)strokeWidth);
        return this;
    }

    public Image snapshot() {
        return new RoboImage(this.gfx, this.image.scale(), ((RoboImage)this.image).cgImage(), "<canvas>");
    }

    public Canvas strokeCircle(float x, float y, float radius) {
        this.bctx.strokeEllipseInRect(new CGRect((double)(x - radius), (double)(y - radius), (double)(2.0f * radius), (double)(2.0f * radius)));
        this.isDirty = true;
        return this;
    }

    public Canvas strokePath(Path path) {
        this.bctx.addPath((CGPath)((RoboPath)path).cgPath);
        this.bctx.strokePath();
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRect(float x, float y, float width, float height) {
        this.bctx.strokeRect(new CGRect((double)x, (double)y, (double)width, (double)height));
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRoundRect(float x, float y, float width, float height, float radius) {
        this.addRoundRectPath(x, y, width, height, radius);
        this.bctx.strokePath();
        this.isDirty = true;
        return this;
    }

    public Canvas strokeText(TextLayout layout, float x, float y) {
        ((RoboTextLayout)layout).stroke(this.bctx, x, y, this.strokeWidth, this.strokeColor);
        this.isDirty = true;
        return this;
    }

    public Canvas transform(float m11, float m12, float m21, float m22, float dx, float dy) {
        this.bctx.concatCTM(new CGAffineTransform((double)m11, (double)m12, (double)m21, (double)m22, (double)dx, (double)dy));
        return this;
    }

    public Canvas translate(float x, float y) {
        this.bctx.translateCTM((double)x, (double)y);
        return this;
    }

    protected CGBitmapContext gc() {
        return this.bctx;
    }

    private void addRoundRectPath(float x, float y, float width, float height, float radius) {
        float midx = x + width / 2.0f;
        float midy = y + height / 2.0f;
        float maxx = x + width;
        float maxy = y + height;
        this.bctx.beginPath();
        this.bctx.moveToPoint((double)x, (double)midy);
        this.bctx.addArcToPoint((double)x, (double)y, (double)midx, (double)y, (double)radius);
        this.bctx.addArcToPoint((double)maxx, (double)y, (double)maxx, (double)midy, (double)radius);
        this.bctx.addArcToPoint((double)maxx, (double)maxy, (double)midx, (double)maxy, (double)radius);
        this.bctx.addArcToPoint((double)x, (double)maxy, (double)x, (double)midy, (double)radius);
        this.bctx.closePath();
    }

    private RoboCanvasState currentState() {
        return this.states.peek();
    }

    static void setStrokeColor(CGBitmapContext bctx, int color) {
        float blue = (float)(color & 0xFF) / 255.0f;
        float green = (float)((color >>= 8) & 0xFF) / 255.0f;
        float red = (float)((color >>= 8) & 0xFF) / 255.0f;
        float alpha = (float)((color >>= 8) & 0xFF) / 255.0f;
        bctx.setRGBStrokeColor((double)red, (double)green, (double)blue, (double)alpha);
    }

    static void setFillColor(CGBitmapContext bctx, int color) {
        float blue = (float)(color & 0xFF) / 255.0f;
        float green = (float)((color >>= 8) & 0xFF) / 255.0f;
        float red = (float)((color >>= 8) & 0xFF) / 255.0f;
        float alpha = (float)((color >>= 8) & 0xFF) / 255.0f;
        bctx.setRGBFillColor((double)red, (double)green, (double)blue, (double)alpha);
    }

    static {
        compToBlend.put(Canvas.Composite.SRC, CGBlendMode.Copy);
        compToBlend.put(Canvas.Composite.DST_ATOP, CGBlendMode.DestinationAtop);
        compToBlend.put(Canvas.Composite.SRC_OVER, CGBlendMode.Normal);
        compToBlend.put(Canvas.Composite.DST_OVER, CGBlendMode.DestinationOver);
        compToBlend.put(Canvas.Composite.SRC_IN, CGBlendMode.SourceIn);
        compToBlend.put(Canvas.Composite.DST_IN, CGBlendMode.DestinationIn);
        compToBlend.put(Canvas.Composite.SRC_OUT, CGBlendMode.SourceOut);
        compToBlend.put(Canvas.Composite.DST_OUT, CGBlendMode.DestinationOut);
        compToBlend.put(Canvas.Composite.SRC_ATOP, CGBlendMode.SourceAtop);
        compToBlend.put(Canvas.Composite.XOR, CGBlendMode.XOR);
        compToBlend.put(Canvas.Composite.MULTIPLY, CGBlendMode.Multiply);
        decodeCap = new HashMap<Canvas.LineCap, CGLineCap>();
        decodeCap.put(Canvas.LineCap.BUTT, CGLineCap.Butt);
        decodeCap.put(Canvas.LineCap.ROUND, CGLineCap.Round);
        decodeCap.put(Canvas.LineCap.SQUARE, CGLineCap.Square);
        decodeJoin = new HashMap<Canvas.LineJoin, CGLineJoin>();
        decodeJoin.put(Canvas.LineJoin.BEVEL, CGLineJoin.Bevel);
        decodeJoin.put(Canvas.LineJoin.MITER, CGLineJoin.Miter);
        decodeJoin.put(Canvas.LineJoin.ROUND, CGLineJoin.Round);
    }
}

