/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.util.HashMap;
import java.util.Map;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coretext.CTFont;
import playn.core.Font;

public class RoboFont {
    private static Map<Font, CTFont> fonts = new HashMap<Font, CTFont>();
    private static Map<Font.Style, Map<String, String>> _variants = new HashMap<Font.Style, Map<String, String>>();
    private static final Font DEFAULT_FONT;

    public static void registerVariant(String name, Font.Style style, String variantName) {
        Map<String, String> styleVariants = _variants.get(style);
        if (styleVariants == null) {
            styleVariants = new HashMap<String, String>();
            _variants.put(style, styleVariants);
        }
        styleVariants.put(name, variantName);
    }

    static CTFont resolveFont(Font font) {
        CTFont ctFont = fonts.get(font == null ? DEFAULT_FONT : font);
        if (ctFont == null) {
            String iosName = RoboFont.getVariant(font.name, font.style);
            ctFont = CTFont.create((String)iosName, (double)font.size, (CGAffineTransform)CGAffineTransform.Identity());
            fonts.put(font, ctFont);
        }
        return ctFont;
    }

    private static String getVariant(String name, Font.Style style) {
        String variant;
        Map<String, String> styleVariants = _variants.get(style);
        String string = variant = styleVariants == null ? null : styleVariants.get(name);
        if (variant != null) {
            return variant;
        }
        if (style == Font.Style.BOLD_ITALIC) {
            return RoboFont.getVariant(name, Font.Style.BOLD);
        }
        return name;
    }

    static {
        RoboFont.registerVariant("American Typewriter", Font.Style.PLAIN, "AmericanTypewriter");
        RoboFont.registerVariant("American Typewriter", Font.Style.BOLD, "AmericanTypewriter-Bold");
        RoboFont.registerVariant("Arial", Font.Style.PLAIN, "ArialMT");
        RoboFont.registerVariant("Arial", Font.Style.ITALIC, "Arial-ItalicMT");
        RoboFont.registerVariant("Arial", Font.Style.BOLD, "Arial-BoldMT");
        RoboFont.registerVariant("Arial", Font.Style.BOLD_ITALIC, "Arial-BoldItalicMT");
        RoboFont.registerVariant("Arial Hebrew", Font.Style.PLAIN, "ArialHebrew");
        RoboFont.registerVariant("Arial Hebrew", Font.Style.BOLD, "ArialHebrew-Bold");
        RoboFont.registerVariant("Baskerville", Font.Style.BOLD, "Baskerville-Bold");
        RoboFont.registerVariant("Baskerville", Font.Style.ITALIC, "Baskerville-Italic");
        RoboFont.registerVariant("Baskerville", Font.Style.BOLD_ITALIC, "Baskerville-BoldItalic");
        RoboFont.registerVariant("Chalkboard SE", Font.Style.PLAIN, "ChalkboardSE-Regular");
        RoboFont.registerVariant("Chalkboard SE", Font.Style.BOLD, "ChalkboardSE-Bold");
        RoboFont.registerVariant("Cochin", Font.Style.BOLD, "Cochin-Bold");
        RoboFont.registerVariant("Cochin", Font.Style.ITALIC, "Cochin-Italic");
        RoboFont.registerVariant("Cochin", Font.Style.BOLD_ITALIC, "Cochin-BoldItalic");
        RoboFont.registerVariant("Courier", Font.Style.BOLD, "Courier-Bold");
        RoboFont.registerVariant("Courier", Font.Style.ITALIC, "Courier-Oblique");
        RoboFont.registerVariant("Courier", Font.Style.BOLD_ITALIC, "Courier-BoldOblique");
        RoboFont.registerVariant("Courier New", Font.Style.PLAIN, "CourierNewPSMT");
        RoboFont.registerVariant("Courier New", Font.Style.BOLD, "CourierNewPS-BoldMT");
        RoboFont.registerVariant("Courier New", Font.Style.ITALIC, "CourierNewPS-ItalicMT");
        RoboFont.registerVariant("Courier New", Font.Style.BOLD_ITALIC, "CourierNewPS-BoldItalicMT");
        RoboFont.registerVariant("Georgia", Font.Style.ITALIC, "Georgia-Italic");
        RoboFont.registerVariant("Georgia", Font.Style.BOLD, "Georgia-Bold");
        RoboFont.registerVariant("Georgia", Font.Style.BOLD_ITALIC, "Georgia-BoldItalic");
        RoboFont.registerVariant("Helvetica", Font.Style.BOLD, "Helvetica-Bold");
        RoboFont.registerVariant("Helvetica", Font.Style.ITALIC, "Helvetica-Oblique");
        RoboFont.registerVariant("Helvetica", Font.Style.BOLD_ITALIC, "Helvetica-Bold-Oblique");
        RoboFont.registerVariant("Helvetica Neue", Font.Style.PLAIN, "HelveticaNeue");
        RoboFont.registerVariant("Helvetica Neue", Font.Style.BOLD, "HelveticaNeue-Bold");
        RoboFont.registerVariant("Helvetica Neue", Font.Style.ITALIC, "HelveticaNeue-Italic");
        RoboFont.registerVariant("Helvetica Neue", Font.Style.BOLD_ITALIC, "HelveticaNeue-BoldItalic");
        RoboFont.registerVariant("Palatino", Font.Style.PLAIN, "Palatino-Romain");
        RoboFont.registerVariant("Palatino", Font.Style.ITALIC, "Palatino-Italic");
        RoboFont.registerVariant("Palatino", Font.Style.BOLD, "Palatino-Bold");
        RoboFont.registerVariant("Palatino", Font.Style.BOLD_ITALIC, "Palatino-BoldItalic");
        RoboFont.registerVariant("Times New Roman", Font.Style.PLAIN, "TimesNewRomanPSMT");
        RoboFont.registerVariant("Times New Roman", Font.Style.ITALIC, "TimesNewRomanPS-ItalicMT");
        RoboFont.registerVariant("Times New Roman", Font.Style.BOLD, "TimesNewRomanPS-BoldMT");
        RoboFont.registerVariant("Times New Roman", Font.Style.BOLD_ITALIC, "TimesNewRomanPS-BoldItalicMT");
        RoboFont.registerVariant("Trebuchet MS", Font.Style.PLAIN, "TrebuchetMS");
        RoboFont.registerVariant("Trebuchet MS", Font.Style.ITALIC, "TrebuchetMS-Italic");
        RoboFont.registerVariant("Trebuchet MS", Font.Style.BOLD, "TrebuchetMS-Bold");
        RoboFont.registerVariant("Trebuchet MS", Font.Style.BOLD_ITALIC, "Trebuchet-BoldItalic");
        RoboFont.registerVariant("Verdana", Font.Style.ITALIC, "Verdana-Italic");
        RoboFont.registerVariant("Verdana", Font.Style.BOLD, "Verdana-Bold");
        RoboFont.registerVariant("Verdana", Font.Style.BOLD_ITALIC, "Verdana-BoldItalic");
        RoboFont.registerVariant("Times", Font.Style.PLAIN, "TimesNewRomanPSMT");
        RoboFont.registerVariant("Times", Font.Style.ITALIC, "TimesNewRomanPS-ItalicMT");
        RoboFont.registerVariant("Times", Font.Style.BOLD, "TimesNewRomanPS-BoldMT");
        RoboFont.registerVariant("Times", Font.Style.BOLD_ITALIC, "TimesNewRomanPS-BoldItalicMT");
        DEFAULT_FONT = new Font("Helvetica", Font.Style.PLAIN, 12.0f);
    }
}

