/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import playn.core.Platform;
import playn.java.JavaGraphics;
import playn.java.JavaInput;
import playn.java.JavaPlatform;
import playn.java.SWTGraphics;
import playn.java.SWTInput;

public class SWTPlatform
extends JavaPlatform {
    protected static final long FRAME_MILLIS = 16L;
    private long lastFrame;
    Display display;
    Shell shell;
    Composite comp;

    public Shell shell() {
        return this.shell;
    }

    public Composite composite() {
        return this.comp;
    }

    public SWTPlatform(JavaPlatform.Config config) {
        super(config);
    }

    public void setTitle(String title) {
        this.shell.setText(title);
    }

    public SWTGraphics graphics() {
        return (SWTGraphics)super.graphics();
    }

    public void start() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            long now = this.tick();
            if (now - this.lastFrame >= 16L) {
                this.graphics().onBeforeFrame();
                this.emitFrame();
                this.graphics().onAfterFrame();
                this.lastFrame = now;
            }
            if (this.display.readAndDispatch()) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.display.dispose();
        this.shutdown();
    }

    protected void preInit() {
        Display.setAppName((String)this.config.appName);
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                SWTPlatform.this.lifecycle.emit((Object)Platform.Lifecycle.RESUME);
            }

            public void shellDeactivated(ShellEvent e) {
                SWTPlatform.this.lifecycle.emit((Object)Platform.Lifecycle.PAUSE);
            }
        });
        this.comp = new Composite((Composite)this.shell, 0);
        this.comp.setLayout(null);
    }

    protected JavaGraphics createGraphics() {
        return new SWTGraphics(this, this.comp);
    }

    protected JavaInput createInput() {
        return new SWTInput(this);
    }
}

