/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLContext;
import playn.java.JavaPlatform;
import playn.java.LWJGLGraphics;
import playn.java.SWTPlatform;

public class SWTGraphics
extends LWJGLGraphics {
    private final SWTPlatform plat;
    GLCanvas canvas;

    public SWTGraphics(SWTPlatform plat, final Composite comp) {
        super((JavaPlatform)plat);
        this.plat = plat;
        GLData data = new GLData();
        data.doubleBuffer = true;
        this.canvas = new GLCanvas(comp, 0, data);
        this.makeCurrent();
        comp.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = comp.getBounds();
                comp.setBounds(bounds);
                SWTGraphics.this.canvas.setBounds(bounds);
                SWTGraphics.this.makeCurrent();
                SWTGraphics.this.viewportChanged(SWTGraphics.this.scale, bounds.width, bounds.height);
            }
        });
        this.setSize(plat.config.width, plat.config.height, plat.config.fullscreen);
    }

    public GLCanvas canvas() {
        return this.canvas;
    }

    public void setSize(int width, int height, boolean fullscreen) {
        int rawWidth = this.scale.scaledCeil((float)width);
        int rawHeight = this.scale.scaledCeil((float)height);
        this.plat.comp.setSize(rawWidth, rawHeight);
        this.plat.shell.setFullScreen(fullscreen);
        this.plat.shell.pack();
    }

    protected void init() {
    }

    protected void setDisplayMode(int width, int height, boolean fullscreen) {
    }

    private void makeCurrent() {
        this.canvas.setCurrent();
        try {
            GLContext.useContext((Object)this.canvas);
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    void onBeforeFrame() {
        this.makeCurrent();
    }

    void onAfterFrame() {
        this.canvas.swapBuffers();
    }
}

