/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import javax.swing.JOptionPane;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.java.JavaInput;
import playn.java.JavaPlatform;
import playn.java.LWJGLPlatform;
import pythagoras.f.Point;
import react.RFuture;

public class LWJGLInput
extends JavaInput {
    public LWJGLInput(LWJGLPlatform plat) {
        super((JavaPlatform)plat);
        try {
            Keyboard.create();
            Mouse.create();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initVal) {
        Object result = JOptionPane.showInputDialog(null, label, "", 3, null, null, initVal);
        return RFuture.success((Object)((String)result));
    }

    public RFuture<Boolean> sysDialog(String title, String text, String ok, String cancel) {
        Object[] objectArray;
        int msgType;
        int optType = 2;
        int n = msgType = cancel == null ? 1 : 3;
        if (cancel == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ok;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = ok;
            objectArray = objectArray3;
            objectArray3[1] = cancel;
        }
        Object[] options = objectArray;
        String defOption = cancel == null ? ok : cancel;
        int result = JOptionPane.showOptionDialog(null, text, title, optType, msgType, null, options, defOption);
        return RFuture.success((Object)(result == 0 ? 1 : 0));
    }

    public boolean hasMouseLock() {
        return true;
    }

    public boolean isMouseLocked() {
        return Mouse.isGrabbed();
    }

    public void setMouseLocked(boolean locked) {
        Mouse.setGrabbed((boolean)locked);
    }

    void update() {
        double time;
        super.update();
        Keyboard.poll();
        int flags = this.modifierFlags(Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184), Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157), Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220), Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
        while (Keyboard.next()) {
            Key key;
            time = Keyboard.getEventNanoseconds() / 1000000L;
            int keyCode = Keyboard.getEventKey();
            if (Keyboard.getEventKeyState()) {
                char keyChar;
                key = this.translateKey(keyCode);
                if (key != null) {
                    this.emitKeyPress(flags, time, key, true);
                }
                if (Character.isISOControl(keyChar = Keyboard.getEventCharacter())) continue;
                this.emitKeyTyped(time, keyChar);
                continue;
            }
            key = this.translateKey(keyCode);
            if (key == null) continue;
            this.emitKeyPress(flags, time, key, false);
        }
        while (Mouse.next()) {
            time = Mouse.getEventNanoseconds() / 1000000L;
            Point m = new Point((float)Mouse.getEventX(), (float)(Display.getHeight() - Mouse.getEventY() - 1));
            int btnIdx = Mouse.getEventButton();
            if (btnIdx >= 0) {
                Mouse.ButtonEvent.Id btn = LWJGLInput.getButton(btnIdx);
                if (btn == null) continue;
                this.emitMouseButton(flags, time, m.x, m.y, btn, Mouse.getEventButtonState());
                continue;
            }
            int wheel = Mouse.getEventDWheel();
            if (wheel != 0) {
                this.emitMouseWheel(flags, time, m.x, m.y, wheel > 0 ? -1 : 1);
                continue;
            }
            this.emitMouseMotion(flags, time, m.x, m.y, Mouse.getEventDX(), -Mouse.getEventDY());
        }
    }

    private Key translateKey(int keyCode) {
        switch (keyCode) {
            case 1: {
                return Key.ESCAPE;
            }
            case 2: {
                return Key.K1;
            }
            case 3: {
                return Key.K2;
            }
            case 4: {
                return Key.K3;
            }
            case 5: {
                return Key.K4;
            }
            case 6: {
                return Key.K5;
            }
            case 7: {
                return Key.K6;
            }
            case 8: {
                return Key.K7;
            }
            case 9: {
                return Key.K8;
            }
            case 10: {
                return Key.K9;
            }
            case 11: {
                return Key.K0;
            }
            case 12: {
                return Key.MINUS;
            }
            case 13: {
                return Key.EQUALS;
            }
            case 14: {
                return Key.BACK;
            }
            case 15: {
                return Key.TAB;
            }
            case 16: {
                return Key.Q;
            }
            case 17: {
                return Key.W;
            }
            case 18: {
                return Key.E;
            }
            case 19: {
                return Key.R;
            }
            case 20: {
                return Key.T;
            }
            case 21: {
                return Key.Y;
            }
            case 22: {
                return Key.U;
            }
            case 23: {
                return Key.I;
            }
            case 24: {
                return Key.O;
            }
            case 25: {
                return Key.P;
            }
            case 26: {
                return Key.LEFT_BRACKET;
            }
            case 27: {
                return Key.RIGHT_BRACKET;
            }
            case 28: {
                return Key.ENTER;
            }
            case 29: {
                return Key.CONTROL;
            }
            case 30: {
                return Key.A;
            }
            case 31: {
                return Key.S;
            }
            case 32: {
                return Key.D;
            }
            case 33: {
                return Key.F;
            }
            case 34: {
                return Key.G;
            }
            case 35: {
                return Key.H;
            }
            case 36: {
                return Key.J;
            }
            case 37: {
                return Key.K;
            }
            case 38: {
                return Key.L;
            }
            case 39: {
                return Key.SEMICOLON;
            }
            case 40: {
                return Key.QUOTE;
            }
            case 41: {
                return Key.BACKQUOTE;
            }
            case 42: {
                return Key.SHIFT;
            }
            case 43: {
                return Key.BACKSLASH;
            }
            case 44: {
                return Key.Z;
            }
            case 45: {
                return Key.X;
            }
            case 46: {
                return Key.C;
            }
            case 47: {
                return Key.V;
            }
            case 48: {
                return Key.B;
            }
            case 49: {
                return Key.N;
            }
            case 50: {
                return Key.M;
            }
            case 51: {
                return Key.COMMA;
            }
            case 52: {
                return Key.PERIOD;
            }
            case 53: {
                return Key.SLASH;
            }
            case 54: {
                return Key.SHIFT;
            }
            case 55: {
                return Key.MULTIPLY;
            }
            case 56: {
                return Key.ALT;
            }
            case 57: {
                return Key.SPACE;
            }
            case 58: {
                return Key.CAPS_LOCK;
            }
            case 59: {
                return Key.F1;
            }
            case 60: {
                return Key.F2;
            }
            case 61: {
                return Key.F3;
            }
            case 62: {
                return Key.F4;
            }
            case 63: {
                return Key.F5;
            }
            case 64: {
                return Key.F6;
            }
            case 65: {
                return Key.F7;
            }
            case 66: {
                return Key.F8;
            }
            case 67: {
                return Key.F9;
            }
            case 68: {
                return Key.F10;
            }
            case 69: {
                return Key.NP_NUM_LOCK;
            }
            case 70: {
                return Key.SCROLL_LOCK;
            }
            case 71: {
                return Key.NP7;
            }
            case 72: {
                return Key.NP8;
            }
            case 73: {
                return Key.NP9;
            }
            case 74: {
                return Key.NP_SUBTRACT;
            }
            case 75: {
                return Key.NP4;
            }
            case 76: {
                return Key.NP5;
            }
            case 77: {
                return Key.NP6;
            }
            case 78: {
                return Key.NP_ADD;
            }
            case 79: {
                return Key.NP1;
            }
            case 80: {
                return Key.NP2;
            }
            case 81: {
                return Key.NP3;
            }
            case 82: {
                return Key.NP0;
            }
            case 83: {
                return Key.NP_DECIMAL;
            }
            case 87: {
                return Key.F11;
            }
            case 88: {
                return Key.F12;
            }
            case 144: {
                return Key.CIRCUMFLEX;
            }
            case 145: {
                return Key.AT;
            }
            case 146: {
                return Key.COLON;
            }
            case 147: {
                return Key.UNDERSCORE;
            }
            case 157: {
                return Key.CONTROL;
            }
            case 183: {
                return Key.SYSRQ;
            }
            case 184: {
                return Key.ALT;
            }
            case 196: {
                return Key.FUNCTION;
            }
            case 197: {
                return Key.PAUSE;
            }
            case 199: {
                return Key.HOME;
            }
            case 200: {
                return Key.UP;
            }
            case 201: {
                return Key.PAGE_UP;
            }
            case 203: {
                return Key.LEFT;
            }
            case 205: {
                return Key.RIGHT;
            }
            case 207: {
                return Key.END;
            }
            case 208: {
                return Key.DOWN;
            }
            case 209: {
                return Key.PAGE_DOWN;
            }
            case 210: {
                return Key.INSERT;
            }
            case 211: {
                return Key.DELETE;
            }
            case 218: {
                return Key.CLEAR;
            }
            case 219: {
                return Key.META;
            }
            case 220: {
                return Key.META;
            }
            case 222: {
                return Key.POWER;
            }
        }
        return null;
    }

    private static Mouse.ButtonEvent.Id getButton(int lwjglButton) {
        switch (lwjglButton) {
            case 0: {
                return Mouse.ButtonEvent.Id.LEFT;
            }
            case 2: {
                return Mouse.ButtonEvent.Id.MIDDLE;
            }
            case 1: {
                return Mouse.ButtonEvent.Id.RIGHT;
            }
        }
        return null;
    }
}

