/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.File;
import java.lang.reflect.Method;
import org.lwjgl.opengl.Display;
import playn.core.Platform;
import playn.java.JavaGraphics;
import playn.java.JavaInput;
import playn.java.JavaPlatform;
import playn.java.LWJGLGraphics;
import playn.java.LWJGLInput;
import playn.java.SharedLibraryExtractor;

public class LWJGLPlatform
extends JavaPlatform {
    private LWJGLGraphics graphics;
    private LWJGLInput input;

    public LWJGLPlatform(JavaPlatform.Config config) {
        super(config);
        if (!this.isInJavaWebStart()) {
            SharedLibraryExtractor extractor = new SharedLibraryExtractor();
            File nativesDir = null;
            try {
                nativesDir = extractor.extractLibrary("lwjgl", null).getParentFile();
            }
            catch (Throwable ex) {
                throw new RuntimeException("Unable to extract LWJGL native libraries.", ex);
            }
            System.setProperty("org.lwjgl.librarypath", nativesDir.getAbsolutePath());
        }
        this.graphics = new LWJGLGraphics(this);
        this.input = new LWJGLInput(this);
    }

    public JavaGraphics graphics() {
        return this.graphics;
    }

    public JavaInput input() {
        return this.input;
    }

    protected void loop() {
        boolean wasActive = Display.isActive();
        while (!Display.isCloseRequested()) {
            boolean newActive = Display.isActive();
            if (wasActive != newActive) {
                this.dispatchEvent(this.lifecycle, wasActive ? Platform.Lifecycle.PAUSE : Platform.Lifecycle.RESUME);
                wasActive = newActive;
            }
            ((LWJGLGraphics)this.graphics()).checkScaleFactor();
            if (newActive || !this.config.truePause) {
                this.processFrame();
            }
            Display.update();
            Display.sync((int)60);
        }
    }

    private boolean isInJavaWebStart() {
        try {
            Method method = Class.forName("javax.jnlp.ServiceManager").getDeclaredMethod("lookup", String.class);
            method.invoke(null, "javax.jnlp.PersistenceService");
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

