/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import playn.core.GL20;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.Texture;
import playn.java.JavaGraphics;
import playn.java.JavaPlatform;
import playn.java.LWJGLGL20;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;

public class LWJGLGraphics
extends JavaGraphics {
    private final Dimension screenSize = new Dimension();

    public LWJGLGraphics(JavaPlatform plat) {
        super((Platform)plat, (GL20)new LWJGLGL20(), Scale.ONE);
        this.setDisplayMode(plat.config.width, plat.config.height, plat.config.fullscreen);
        try {
            System.setProperty("org.lwjgl.opengl.Display.enableHighDPI", "true");
            Display.create();
            this.checkScaleFactor();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    void checkScaleFactor() {
        float scaleFactor = Display.getPixelScaleFactor();
        if (scaleFactor != this.scale().factor) {
            this.updateViewport(new Scale(scaleFactor), Display.getWidth(), Display.getHeight());
        }
    }

    public void setTitle(String title) {
        Display.setTitle((String)title);
    }

    public IDimension screenSize() {
        DisplayMode mode = Display.getDesktopDisplayMode();
        this.screenSize.width = this.scale().invScaled((float)mode.getWidth());
        this.screenSize.height = this.scale().invScaled((float)mode.getHeight());
        return this.screenSize;
    }

    public void setSize(int width, int height, boolean fullscreen) {
        this.setDisplayMode(width, height, fullscreen);
    }

    protected void upload(BufferedImage img, Texture tex) {
        int type;
        int format;
        ByteBuffer bbuf;
        BufferedImage bitmap = LWJGLGraphics.convertImage((BufferedImage)img);
        DataBuffer dbuf = bitmap.getRaster().getDataBuffer();
        if (bitmap.getType() == 3) {
            DataBufferInt ibuf = (DataBufferInt)dbuf;
            int iSize = ibuf.getSize() * 4;
            bbuf = this.checkGetImageBuffer(iSize);
            bbuf.asIntBuffer().put(ibuf.getData());
            bbuf.position(bbuf.position() + iSize);
            bbuf.flip();
            format = 32993;
            type = 33639;
        } else if (bitmap.getType() == 6) {
            DataBufferByte dbbuf = (DataBufferByte)dbuf;
            bbuf = this.checkGetImageBuffer(dbbuf.getSize());
            bbuf.put(dbbuf.getData());
            bbuf.flip();
            format = 6408;
            type = 32821;
        } else {
            throw new RuntimeException("Image type wasn't converted to usable: " + bitmap.getType());
        }
        this.gl.glBindTexture(3553, tex.id);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (int)0, (int)format, (int)type, (ByteBuffer)bbuf);
        this.gl.checkError("updateTexture");
    }

    protected void setDisplayMode(int width, int height, boolean fullscreen) {
        try {
            Scale scale;
            DisplayMode mode = Display.getDisplayMode();
            if (fullscreen == Display.isFullscreen() && mode.getWidth() == width && mode.getHeight() == height) {
                return;
            }
            if (!fullscreen) {
                mode = new DisplayMode(width, height);
            } else {
                DisplayMode matching = null;
                for (DisplayMode dm : Display.getAvailableDisplayModes()) {
                    if (dm.getWidth() != width || dm.getHeight() != height || !dm.isFullscreenCapable()) continue;
                    matching = dm;
                }
                if (matching != null) {
                    mode = matching;
                } else {
                    this.plat.log().info("Could not find a matching fullscreen mode, available: " + Arrays.asList(Display.getAvailableDisplayModes()));
                }
            }
            this.plat.log().debug("Updating display mode: " + mode + ", fullscreen: " + fullscreen);
            if (fullscreen) {
                Display.setDisplayModeAndFullscreen((DisplayMode)mode);
                scale = Scale.ONE;
            } else {
                Display.setDisplayMode((DisplayMode)mode);
                scale = new Scale(Display.getPixelScaleFactor());
            }
            this.updateViewport(scale, mode.getWidth(), mode.getHeight());
        }
        catch (LWJGLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void updateViewport(Scale scale, float displayWidth, float displayHeight) {
        this.scaleChanged(scale);
        this.viewportChanged(scale.scaledCeil(displayWidth), scale.scaledCeil(displayHeight));
    }
}

