/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import playn.core.Exec;
import playn.core.Net;

public class JavaWebSocket
implements Net.WebSocket {
    private final WebSocketClient socket;

    public JavaWebSocket(final Exec exec, String uri, final Net.WebSocket.Listener listener) {
        URI juri = null;
        try {
            juri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.socket = new WebSocketClient(juri, (Draft)new Draft_6455()){

            public void onMessage(final ByteBuffer buffer) {
                exec.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onDataMessage(buffer);
                    }
                });
            }

            public void onMessage(final String msg) {
                exec.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onTextMessage(msg);
                    }
                });
            }

            public void onError(final Exception e) {
                exec.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onError(e.getMessage());
                    }
                });
            }

            public void onClose(int code, String reason, boolean remote) {
                exec.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onClose();
                    }
                });
            }

            public void onOpen(ServerHandshake handshake) {
                exec.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onOpen();
                    }
                });
            }
        };
        this.socket.connect();
    }

    public void close() {
        this.socket.close();
    }

    public void send(String data) {
        try {
            this.socket.getConnection().send(data);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void send(ByteBuffer data) {
        try {
            this.socket.getConnection().send(data);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

