/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import playn.core.Gradient;

class JavaGradient
extends Gradient {
    Paint paint;

    static JavaGradient create(Gradient.Linear cfg) {
        Point2D.Float start = new Point2D.Float(cfg.x0, cfg.y0);
        Point2D.Float end = new Point2D.Float(cfg.x1, cfg.y1);
        Color[] javaColors = JavaGradient.convertColors(cfg.colors);
        return new JavaGradient(new LinearGradientPaint(start, end, cfg.positions, javaColors));
    }

    static JavaGradient create(Gradient.Radial cfg) {
        Point2D.Float center = new Point2D.Float(cfg.x, cfg.y);
        Color[] javaColors = JavaGradient.convertColors(cfg.colors);
        return new JavaGradient(new RadialGradientPaint(center, cfg.r, cfg.positions, javaColors));
    }

    private static Color[] convertColors(int[] colors) {
        Color[] javaColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            javaColors[i] = new Color(colors[i], true);
        }
        return javaColors;
    }

    private JavaGradient(Paint paint) {
        this.paint = paint;
    }
}

