/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import playn.core.Image;
import playn.core.Net;
import playn.core.Scale;
import playn.java.JavaAssets;
import playn.java.JavaImage;
import playn.java.JavaPlatform;
import playn.java.JavaWebSocket;
import react.RFuture;
import react.RPromise;

public class JavaNet
extends Net {
    private final JavaPlatform plat;

    public JavaNet(JavaPlatform plat) {
        this.plat = plat;
    }

    public Net.WebSocket createWebSocket(String url, Net.WebSocket.Listener listener) {
        return new JavaWebSocket(this.plat.exec(), url, listener);
    }

    protected RFuture<Net.Response> execute(final Net.Builder req) {
        final RPromise result = this.plat.exec().deferredPromise();
        this.plat.exec().invokeAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final URL url = new URL(JavaNet.this.canonicalizeUrl(req.url));
                    final HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    for (Net.Header header : req.headers) {
                        conn.setRequestProperty(header.name, header.value);
                    }
                    conn.setRequestMethod(req.method());
                    if (req.isPost()) {
                        conn.setDoOutput(true);
                        conn.setDoInput(true);
                        conn.setAllowUserInteraction(false);
                        conn.setRequestProperty("Content-type", req.contentType());
                        conn.connect();
                        conn.getOutputStream().write(req.payloadString == null ? req.payloadBytes : req.payloadString.getBytes("UTF-8"));
                        conn.getOutputStream().close();
                    }
                    try {
                        int code = conn.getResponseCode();
                        InputStream stream = code >= 400 ? conn.getErrorStream() : conn.getInputStream();
                        final byte[] payload = stream == null ? new byte[]{} : JavaAssets.toByteArray(stream);
                        String encoding = conn.getContentEncoding();
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        result.succeed((Object)new Net.Response.Binary(code, payload, encoding){

                            public Image payloadImage(Scale scale) throws Exception {
                                BufferedImage image = ImageIO.read(new ByteArrayInputStream(payload));
                                return new JavaImage(JavaNet.this.plat.graphics(), scale, image, url.toString());
                            }

                            protected Map<String, List<String>> extractHeaders() {
                                return conn.getHeaderFields();
                            }
                        });
                    }
                    finally {
                        conn.disconnect();
                    }
                }
                catch (MalformedURLException e) {
                    result.fail((Throwable)e);
                }
                catch (IOException e) {
                    result.fail((Throwable)e);
                }
            }

            public String toString() {
                return "JavaNet." + req.method().toLowerCase() + "(" + req.url + ")";
            }
        });
        return result;
    }

    private String canonicalizeUrl(String url) {
        if (!url.startsWith("http")) {
            return "http://" + this.server() + url;
        }
        return url;
    }

    private String server() {
        return "127.0.0.1:8080";
    }
}

