/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Deque;
import java.util.LinkedList;
import playn.core.Canvas;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.TextLayout;
import playn.java.JavaCanvasState;
import playn.java.JavaGradient;
import playn.java.JavaImage;
import playn.java.JavaPath;
import playn.java.JavaPattern;
import playn.java.JavaTextLayout;
import pythagoras.f.MathUtil;

class JavaCanvas
extends Canvas {
    final Graphics2D g2d;
    private Deque<JavaCanvasState> stateStack = new LinkedList<JavaCanvasState>();
    private Ellipse2D.Float ellipse = new Ellipse2D.Float();
    private Line2D.Float line = new Line2D.Float();
    private Rectangle2D.Float rect = new Rectangle2D.Float();
    private RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float();

    public JavaCanvas(Graphics gfx, JavaImage image) {
        super(gfx, (Image)image);
        this.g2d = image.bufferedImage().createGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float scale = image.scale().factor;
        this.g2d.scale(scale, scale);
        this.stateStack.push(new JavaCanvasState());
        this.g2d.setBackground(new Color(0, true));
    }

    public float alpha() {
        return this.currentState().alpha;
    }

    public Image snapshot() {
        BufferedImage bmp = ((JavaImage)this.image).bufferedImage();
        ColorModel cm = bmp.getColorModel();
        boolean isAlphaPremultiplied = bmp.isAlphaPremultiplied();
        WritableRaster raster = bmp.copyData(null);
        BufferedImage snap = new BufferedImage(cm, raster, isAlphaPremultiplied, null);
        return new JavaImage(this.gfx, this.image.scale(), snap, "<canvas>");
    }

    public Canvas clear() {
        this.currentState().prepareClear(this.g2d);
        this.g2d.clearRect(0, 0, MathUtil.iceil((float)this.width), MathUtil.iceil((float)this.height));
        this.isDirty = true;
        return this;
    }

    public Canvas clearRect(float x, float y, float width, float height) {
        this.currentState().prepareClear(this.g2d);
        this.g2d.clearRect(MathUtil.ifloor((float)x), MathUtil.ifloor((float)y), MathUtil.iceil((float)width), MathUtil.iceil((float)height));
        this.isDirty = true;
        return this;
    }

    public Canvas clip(Path path) {
        this.currentState().clipper = (JavaPath)path;
        return this;
    }

    public Canvas clipRect(float x, float y, float width, float height) {
        final int cx = MathUtil.ifloor((float)x);
        final int cy = MathUtil.ifloor((float)y);
        final int cwidth = MathUtil.iceil((float)width);
        final int cheight = MathUtil.iceil((float)height);
        this.currentState().clipper = new JavaCanvasState.Clipper(){

            @Override
            public void setClip(Graphics2D g2d) {
                g2d.setClip(cx, cy, cwidth, cheight);
            }
        };
        return this;
    }

    public Path createPath() {
        return new JavaPath();
    }

    public Gradient createGradient(Gradient.Config cfg) {
        if (cfg instanceof Gradient.Linear) {
            return JavaGradient.create((Gradient.Linear)cfg);
        }
        if (cfg instanceof Gradient.Radial) {
            return JavaGradient.create((Gradient.Radial)cfg);
        }
        throw new IllegalArgumentException("Unknown config: " + cfg);
    }

    public Canvas drawLine(float x0, float y0, float x1, float y1) {
        this.currentState().prepareStroke(this.g2d);
        this.line.setLine(x0, y0, x1, y1);
        this.g2d.draw(this.line);
        this.isDirty = true;
        return this;
    }

    public Canvas drawPoint(float x, float y) {
        this.currentState().prepareStroke(this.g2d);
        this.g2d.drawLine((int)x, (int)y, (int)x, (int)y);
        this.isDirty = true;
        return this;
    }

    public Canvas drawText(String text, float x, float y) {
        this.currentState().prepareFill(this.g2d);
        this.g2d.drawString(text, x, y);
        this.isDirty = true;
        return this;
    }

    public Canvas fillCircle(float x, float y, float radius) {
        this.currentState().prepareFill(this.g2d);
        this.ellipse.setFrame(x - radius, y - radius, 2.0f * radius, 2.0f * radius);
        this.g2d.fill(this.ellipse);
        this.isDirty = true;
        return this;
    }

    public Canvas fillPath(Path path) {
        this.currentState().prepareFill(this.g2d);
        this.g2d.fill(((JavaPath)path).path);
        this.isDirty = true;
        return this;
    }

    public Canvas fillRect(float x, float y, float width, float height) {
        this.currentState().prepareFill(this.g2d);
        this.rect.setRect(x, y, width, height);
        this.g2d.fill(this.rect);
        this.isDirty = true;
        return this;
    }

    public Canvas fillRoundRect(float x, float y, float width, float height, float radius) {
        this.currentState().prepareFill(this.g2d);
        this.roundRect.setRoundRect(x, y, width, height, radius * 2.0f, radius * 2.0f);
        this.g2d.fill(this.roundRect);
        this.isDirty = true;
        return this;
    }

    public Canvas fillText(TextLayout layout, float x, float y) {
        this.currentState().prepareFill(this.g2d);
        ((JavaTextLayout)layout).fill(this.g2d, x, y);
        this.isDirty = true;
        return this;
    }

    public Canvas restore() {
        this.stateStack.pop();
        this.g2d.setTransform(this.currentState().transform);
        return this;
    }

    public Canvas rotate(float angle) {
        this.g2d.rotate(angle);
        return this;
    }

    public Canvas save() {
        this.currentState().transform = this.g2d.getTransform();
        this.stateStack.push(new JavaCanvasState(this.currentState()));
        return this;
    }

    public Canvas scale(float x, float y) {
        this.g2d.scale(x, y);
        return this;
    }

    public Canvas setAlpha(float alpha) {
        this.currentState().alpha = alpha;
        return this;
    }

    public Canvas setCompositeOperation(Canvas.Composite composite) {
        this.currentState().composite = composite;
        return this;
    }

    public Canvas setFillColor(int color) {
        this.currentState().fillColor = color;
        this.currentState().fillGradient = null;
        this.currentState().fillPattern = null;
        return this;
    }

    public Canvas setFillGradient(Gradient gradient) {
        this.currentState().fillGradient = (JavaGradient)gradient;
        this.currentState().fillPattern = null;
        this.currentState().fillColor = 0;
        return this;
    }

    public Canvas setFillPattern(Pattern pattern) {
        this.currentState().fillPattern = (JavaPattern)pattern;
        this.currentState().fillGradient = null;
        this.currentState().fillColor = 0;
        return this;
    }

    public Canvas setLineCap(Canvas.LineCap cap) {
        this.currentState().lineCap = cap;
        return this;
    }

    public Canvas setLineJoin(Canvas.LineJoin join) {
        this.currentState().lineJoin = join;
        return this;
    }

    public Canvas setMiterLimit(float miter) {
        this.currentState().miterLimit = miter;
        return this;
    }

    public Canvas setStrokeColor(int color) {
        this.currentState().strokeColor = color;
        return this;
    }

    public Canvas setStrokeWidth(float w) {
        this.currentState().strokeWidth = w;
        return this;
    }

    public Canvas strokeCircle(float x, float y, float radius) {
        this.currentState().prepareStroke(this.g2d);
        this.ellipse.setFrame(x - radius, y - radius, 2.0f * radius, 2.0f * radius);
        this.g2d.draw(this.ellipse);
        this.isDirty = true;
        return this;
    }

    public Canvas strokePath(Path path) {
        this.currentState().prepareStroke(this.g2d);
        this.g2d.setColor(new Color(this.currentState().strokeColor, false));
        this.g2d.draw(((JavaPath)path).path);
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRect(float x, float y, float width, float height) {
        this.currentState().prepareStroke(this.g2d);
        this.rect.setRect(x, y, width, height);
        this.g2d.draw(this.rect);
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRoundRect(float x, float y, float width, float height, float radius) {
        this.currentState().prepareStroke(this.g2d);
        this.roundRect.setRoundRect(x, y, width, height, radius * 2.0f, radius * 2.0f);
        this.g2d.draw(this.roundRect);
        this.isDirty = true;
        return this;
    }

    public Canvas strokeText(TextLayout layout, float x, float y) {
        this.currentState().prepareStroke(this.g2d);
        ((JavaTextLayout)layout).stroke(this.g2d, x, y);
        this.isDirty = true;
        return this;
    }

    public Canvas transform(float m11, float m12, float m21, float m22, float dx, float dy) {
        this.g2d.transform(new AffineTransform(m11, m12, m21, m22, dx, dy));
        return this;
    }

    public Canvas translate(float x, float y) {
        this.g2d.translate(x, y);
        return this;
    }

    protected Graphics2D gc() {
        this.currentState().prepareFill(this.g2d);
        return this.g2d;
    }

    private JavaCanvasState currentState() {
        return this.stateStack.getFirst();
    }
}

