/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import playn.core.Audio;
import playn.core.Exec;
import playn.java.BigClip;
import playn.java.JavaAssets;
import playn.java.JavaSound;

public class JavaAudio
extends Audio {
    private final Exec exec;

    public JavaAudio(Exec exec) {
        this.exec = exec;
    }

    public JavaSound createSound(final JavaAssets.Resource rsrc, final boolean music) {
        final JavaSound sound = new JavaSound(this.exec);
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    AudioFormat baseFormat;
                    AudioInputStream ais = rsrc.openAudioStream();
                    Clip clip = AudioSystem.getClip();
                    if (music) {
                        clip = new BigClip(clip);
                    }
                    if ((baseFormat = ais.getFormat()).getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                        AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                        ais = AudioSystem.getAudioInputStream(decodedFormat, ais);
                    }
                    clip.open(ais);
                    sound.succeed(clip);
                }
                catch (Exception e) {
                    sound.fail(e);
                }
            }
        });
        return sound;
    }
}

