/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import playn.core.Assets;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Scale;
import playn.core.Sound;
import playn.java.JavaGraphics;
import playn.java.JavaImage;
import playn.java.JavaPlatform;
import pythagoras.f.MathUtil;

public class JavaAssets
extends Assets {
    private final JavaPlatform plat;
    private File[] directories = new File[0];
    private String pathPrefix = "assets/";
    private Scale assetScale = null;
    protected static final String[] SUFFIXES = new String[]{".wav", ".mp3"};

    public JavaAssets(JavaPlatform plat) {
        super(plat.exec());
        this.plat = plat;
    }

    public void setPathPrefix(String prefix) {
        if (prefix.startsWith("/") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must not start or end with '/'.");
        }
        this.pathPrefix = prefix.length() == 0 ? prefix : prefix + "/";
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void addDirectory(File dir) {
        File[] ndirs = new File[this.directories.length + 1];
        System.arraycopy(this.directories, 0, ndirs, 0, this.directories.length);
        ndirs[ndirs.length - 1] = dir;
        this.directories = ndirs;
    }

    public void setAssetScale(float scaleFactor) {
        this.assetScale = new Scale(scaleFactor);
    }

    public Font getFont(String path) throws Exception {
        return this.requireResource(path).createFont();
    }

    public Image getRemoteImage(final String url, int width, int height) {
        final JavaImage image = new JavaImage(this.plat, true, width, height, url);
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedImage bmp = ImageIO.read(new URL(url));
                    image.succeed(new ImageImpl.Data(Scale.ONE, (Object)bmp, bmp.getWidth(), bmp.getHeight()));
                }
                catch (Exception error) {
                    image.fail(error);
                }
            }
        });
        return image;
    }

    public Sound getSound(String path) {
        return this.getSound(path, false);
    }

    public Sound getMusic(String path) {
        return this.getSound(path, true);
    }

    public String getTextSync(String path) throws Exception {
        return this.requireResource(path).readString();
    }

    public byte[] getBytesSync(String path) throws Exception {
        return this.requireResource(path).readBytes();
    }

    protected Sound getSound(String path, boolean music) {
        Exception err = null;
        for (String suff : SUFFIXES) {
            String soundPath = path + suff;
            try {
                return this.plat.audio().createSound(this.requireResource(soundPath), music);
            }
            catch (Exception e) {
                err = e;
            }
        }
        this.plat.log().warn("Sound load error " + path + ": " + err);
        return new Sound.Error(err);
    }

    protected Resource requireResource(String path) throws IOException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.pathPrefix + path);
        if (url != null) {
            return url.getProtocol().equals("file") ? new FileResource(new File(url.getPath())) : new URLResource(url);
        }
        for (File dir : this.directories) {
            File f = new File(dir, path).getCanonicalFile();
            if (!f.exists()) continue;
            return new FileResource(f);
        }
        throw new FileNotFoundException(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] toByteArray(InputStream in) throws IOException {
        try {
            byte[] buffer = new byte[512];
            int size = 0;
            int read = 0;
            while ((read = in.read(buffer, size, buffer.length - size)) > 0) {
                if ((size += read) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, size * 2);
            }
            if (size < buffer.length) {
                buffer = Arrays.copyOf(buffer, size);
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    protected BufferedImage scaleImage(BufferedImage image, float viewImageRatio) {
        int swidth = MathUtil.iceil((float)(viewImageRatio * (float)image.getWidth()));
        int sheight = MathUtil.iceil((float)(viewImageRatio * (float)image.getHeight()));
        BufferedImage scaled = new BufferedImage(swidth, sheight, 3);
        Graphics2D gfx = scaled.createGraphics();
        gfx.drawImage(image.getScaledInstance(swidth, sheight, 4), 0, 0, null);
        gfx.dispose();
        return scaled;
    }

    protected Scale assetScale() {
        return this.assetScale != null ? this.assetScale : this.plat.graphics().scale();
    }

    protected ImageImpl.Data load(String path) throws Exception {
        FileNotFoundException error = null;
        for (Scale.ScaledResource rsrc : this.assetScale().getScaledResources(path)) {
            try {
                BufferedImage convertedImage;
                BufferedImage image = this.requireResource(rsrc.path).readImage();
                Scale viewScale = this.plat.graphics().scale();
                Scale imageScale = rsrc.scale;
                float viewImageRatio = viewScale.factor / imageScale.factor;
                if (viewImageRatio < 1.0f) {
                    image = this.scaleImage(image, viewImageRatio);
                    imageScale = viewScale;
                }
                if (this.plat.config.convertImagesOnLoad && (convertedImage = JavaGraphics.convertImage(image)) != image) {
                    this.plat.log().debug("Converted image: " + path + " [type=" + image.getType() + "]");
                    image = convertedImage;
                }
                return new ImageImpl.Data(imageScale, (Object)image, image.getWidth(), image.getHeight());
            }
            catch (FileNotFoundException fnfe) {
                error = fnfe;
            }
        }
        this.plat.log().warn("Could not load image: " + path + " [error=" + error + "]");
        throw error != null ? error : new FileNotFoundException(path);
    }

    protected ImageImpl createImage(boolean async, int rwid, int rhei, String source) {
        return new JavaImage(this.plat, async, rwid, rhei, source);
    }

    protected static class FileResource
    extends Resource {
        public final File file;

        public FileResource(File file) {
            this.file = file;
        }

        @Override
        public InputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public BufferedImage readImage() throws IOException {
            return ImageIO.read(this.file);
        }

        @Override
        public AudioInputStream openAudioStream() throws Exception {
            return AudioSystem.getAudioInputStream(this.file);
        }

        @Override
        public Font createFont() throws Exception {
            return Font.createFont(0, this.file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] readBytes() throws IOException {
            try (InputStream in = this.openStream();){
                byte[] buffer = new byte[(int)this.file.length()];
                in.read(buffer);
                byte[] byArray = buffer;
                return byArray;
            }
        }
    }

    protected static class URLResource
    extends Resource {
        public final URL url;

        public URLResource(URL url) {
            this.url = url;
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        @Override
        public BufferedImage readImage() throws IOException {
            return ImageIO.read(this.url);
        }
    }

    static abstract class Resource {
        Resource() {
        }

        public abstract BufferedImage readImage() throws IOException;

        public abstract InputStream openStream() throws IOException;

        public AudioInputStream openAudioStream() throws Exception {
            return AudioSystem.getAudioInputStream(this.openStream());
        }

        public Font createFont() throws Exception {
            return Font.createFont(0, this.openStream());
        }

        public byte[] readBytes() throws IOException {
            return JavaAssets.toByteArray(this.openStream());
        }

        public String readString() throws Exception {
            return new String(this.readBytes(), "UTF-8");
        }
    }
}

