/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import playn.core.Input;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.core.Touch;
import playn.java.JavaPlatform;
import pythagoras.f.Point;
import react.Slot;

public class JavaInput
extends Input {
    protected final JavaPlatform plat;
    private final Deque<Keyboard.Event> kevQueue = new ConcurrentLinkedDeque<Keyboard.Event>();
    private boolean mouseDown;
    private Point pivot;
    private float x;
    private float y;
    private int currentId;

    public JavaInput(JavaPlatform plat) {
        this.plat = plat;
        if (plat.config.emulateTouch) {
            this.emulateTouch();
        }
    }

    public void postKey(long time, Key key, boolean pressed, char typedCh) {
        this.kevQueue.add((Keyboard.Event)(key == null ? new Keyboard.TypedEvent(0, (double)time, typedCh) : new Keyboard.KeyEvent(0, (double)time, key, pressed)));
    }

    protected void emulateTouch() {
        final Key pivotKey = this.plat.config.pivotKey;
        this.keyboardEvents.connect((Slot)new Slot<Keyboard.Event>(){

            public void onEmit(Keyboard.Event event) {
                if (event instanceof Keyboard.KeyEvent) {
                    Keyboard.KeyEvent kevent = (Keyboard.KeyEvent)event;
                    if (kevent.key == pivotKey && kevent.down) {
                        JavaInput.this.pivot = new Point(JavaInput.this.x, JavaInput.this.y);
                    }
                }
            }
        });
        this.mouseEvents.connect((Slot)new Slot<Mouse.Event>(){

            public void onEmit(Mouse.Event event) {
                if (event instanceof Mouse.ButtonEvent) {
                    Mouse.ButtonEvent bevent = (Mouse.ButtonEvent)event;
                    if (bevent.button == Mouse.ButtonEvent.Id.LEFT) {
                        if (JavaInput.this.mouseDown = bevent.down) {
                            JavaInput.this.currentId = JavaInput.this.currentId + 2;
                            JavaInput.this.dispatchTouch(event, Touch.Event.Kind.START);
                        } else {
                            JavaInput.this.pivot = null;
                            JavaInput.this.dispatchTouch(event, Touch.Event.Kind.END);
                        }
                    }
                } else if (event instanceof Mouse.MotionEvent) {
                    if (JavaInput.this.mouseDown) {
                        JavaInput.this.dispatchTouch(event, Touch.Event.Kind.MOVE);
                    }
                    JavaInput.this.x = event.x;
                    JavaInput.this.y = event.y;
                }
            }
        });
    }

    public boolean hasHardwareKeyboard() {
        return true;
    }

    public boolean hasTouch() {
        return this.plat.config.emulateTouch;
    }

    void init() {
    }

    void update() {
        Keyboard.Event kev;
        while ((kev = this.kevQueue.poll()) != null) {
            this.keyboardEvents.emit((Object)kev);
        }
    }

    private void dispatchTouch(Mouse.Event event, Touch.Event.Kind kind) {
        Touch.Event[] eventArray;
        float ex = event.x;
        float ey = event.y;
        Touch.Event main = this.toTouch(event.time, ex, ey, kind, 0);
        if (this.pivot == null) {
            Touch.Event[] eventArray2 = new Touch.Event[1];
            eventArray = eventArray2;
            eventArray2[0] = main;
        } else {
            Touch.Event[] eventArray3 = new Touch.Event[2];
            eventArray3[0] = main;
            eventArray = eventArray3;
            eventArray3[1] = this.toTouch(event.time, 2.0f * this.pivot.x - ex, 2.0f * this.pivot.y - ey, kind, 1);
        }
        Touch.Event[] evs = eventArray;
        this.touchEvents.emit((Object)evs);
    }

    private Touch.Event toTouch(double time, float x, float y, Touch.Event.Kind kind, int idoff) {
        return new Touch.Event(0, time, x, y, kind, this.currentId + idoff);
    }
}

