/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Pattern;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.Texture;
import playn.java.JavaBitmapTransformer;
import playn.java.JavaGraphics;
import playn.java.JavaPattern;
import playn.java.JavaPlatform;
import pythagoras.f.MathUtil;

public class JavaImage
extends ImageImpl {
    protected BufferedImage img;

    public JavaImage(Graphics gfx, Scale scale, BufferedImage img) {
        super(gfx, scale, img.getWidth(), img.getHeight(), (Object)img);
    }

    public JavaImage(JavaPlatform plat, boolean async, int preWidth, int preHeight) {
        super((Platform)plat, async, Scale.ONE, preWidth, preHeight);
    }

    public BufferedImage bufferedImage() {
        return this.img;
    }

    public Pattern createPattern(boolean repeatX, boolean repeatY) {
        assert (this.img != null) : "Cannot generate a pattern from unready image.";
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.width(), this.height());
        return new JavaPattern(repeatX, repeatY, new TexturePaint(this.img, rect));
    }

    public void getRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        this.img.getRGB(startX, startY, width, height, rgbArray, offset, scanSize);
    }

    public void setRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        this.img.setRGB(startX, startY, width, height, rgbArray, offset, scanSize);
    }

    public Image transform(Image.BitmapTransformer xform) {
        return new JavaImage(this.gfx, this.scale, ((JavaBitmapTransformer)xform).transform(this.img));
    }

    public void draw(Object ctx, float x, float y, float w, float h) {
        AffineTransform tx = new AffineTransform(w / (float)this.img.getWidth(), 0.0f, 0.0f, h / (float)this.img.getHeight(), x, y);
        ((Graphics2D)ctx).drawImage(this.img, tx, null);
    }

    public void draw(Object ctx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        float f = this.scale().factor;
        sx *= f;
        sy *= f;
        float scaleX = dw / (sw *= f);
        float scaleY = dh / (sh *= f);
        Graphics2D gfx = (Graphics2D)ctx;
        Shape oclip = gfx.getClip();
        gfx.clipRect(MathUtil.ifloor((float)dx), MathUtil.ifloor((float)dy), MathUtil.iceil((float)dw), MathUtil.iceil((float)dh));
        gfx.drawImage(this.img, new AffineTransform(scaleX, 0.0f, 0.0f, scaleY, dx - sx * scaleX, dy - sy * scaleY), null);
        gfx.setClip(oclip);
    }

    public String toString() {
        return "JavaImage[" + this.img + "]";
    }

    protected void upload(Graphics gfx, Texture tex) {
        ((JavaGraphics)gfx).upload(this.img, tex);
    }

    protected void setBitmap(Object bitmap) {
        this.img = (BufferedImage)bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createErrorBitmap(int rawWidth, int rawHeight) {
        BufferedImage img = new BufferedImage(rawWidth, rawHeight, 3);
        Graphics2D g = img.createGraphics();
        try {
            g.setColor(Color.red);
            for (int yy = 0; yy <= rawHeight / 15; ++yy) {
                for (int xx = 0; xx <= rawWidth / 45; ++xx) {
                    g.drawString("ERROR", xx * 45, yy * 15);
                }
            }
        }
        finally {
            g.dispose();
        }
        return img;
    }
}

