/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import playn.core.Canvas;
import playn.core.GL20;
import playn.core.Graphics;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.core.Texture;
import playn.java.JavaCanvas;
import playn.java.JavaImage;
import playn.java.JavaPlatform;
import playn.java.JavaTextLayout;

public abstract class JavaGraphics
extends Graphics {
    private ByteBuffer imgBuf = JavaGraphics.createImageBuffer(1024);
    private Map<String, Font> fonts = new HashMap<String, Font>();
    protected final JavaPlatform plat;
    final FontRenderContext aaFontContext;
    final FontRenderContext aFontContext;
    private static final int[] STYLE_TO_JAVA = new int[]{0, 1, 2, 3};

    protected JavaGraphics(JavaPlatform plat, GL20 gl20, Scale scale) {
        super((Platform)plat, gl20, scale);
        this.plat = plat;
        Graphics2D aaGfx = new BufferedImage(1, 1, 2).createGraphics();
        aaGfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.aaFontContext = aaGfx.getFontRenderContext();
        Graphics2D aGfx = new BufferedImage(1, 1, 2).createGraphics();
        aGfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.aFontContext = aGfx.getFontRenderContext();
    }

    public void registerFont(String name, String path) {
        try {
            this.fonts.put(name, this.plat.assets().requireResource(path).createFont());
        }
        catch (Exception e) {
            this.plat.reportError("Failed to load font [name=" + name + ", path=" + path + "]", e);
        }
    }

    public abstract void setSize(int var1, int var2, boolean var3);

    public TextLayout layoutText(String text, TextFormat format) {
        return JavaTextLayout.layoutText(this, text, format);
    }

    public TextLayout[] layoutText(String text, TextFormat format, TextWrap wrap) {
        return JavaTextLayout.layoutText(this, text, format, wrap);
    }

    protected Canvas createCanvasImpl(Scale scale, int pixelWidth, int pixelHeight) {
        BufferedImage bitmap = new BufferedImage(pixelWidth, pixelHeight, 3);
        return new JavaCanvas(this, new JavaImage(this, scale, bitmap));
    }

    protected abstract void init();

    protected abstract void upload(BufferedImage var1, Texture var2);

    protected void updateViewport(Scale scale, float displayWidth, float displayHeight) {
        this.viewportChanged(scale, scale.scaledCeil(displayWidth), scale.scaledCeil(displayHeight));
    }

    Font resolveFont(playn.core.Font font) {
        Font jfont = this.fonts.get(font.name);
        if (jfont == null) {
            jfont = new Font(font.name, 0, 12);
            this.fonts.put(font.name, jfont);
        }
        return jfont.deriveFont(STYLE_TO_JAVA[font.style.ordinal()], font.size);
    }

    static BufferedImage convertImage(BufferedImage image) {
        switch (image.getType()) {
            case 3: {
                return image;
            }
            case 6: {
                image.coerceData(true);
                return image;
            }
        }
        BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
        Graphics2D g = convertedImage.createGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return convertedImage;
    }

    ByteBuffer checkGetImageBuffer(int byteSize) {
        if (this.imgBuf.capacity() >= byteSize) {
            this.imgBuf.clear();
        } else {
            this.imgBuf = JavaGraphics.createImageBuffer(byteSize);
        }
        return this.imgBuf;
    }

    private static ByteBuffer createImageBuffer(int byteSize) {
        return ByteBuffer.allocateDirect(byteSize).order(ByteOrder.nativeOrder());
    }
}

