/*
 * Decompiled with CFR 0.152.
 */
package playn.core.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import playn.core.Json;

public class JsonTypedArray<T>
implements Json.TypedArray<T> {
    private final Json.Array array;
    private Getter<T> getter;
    private static Map<Class<?>, Getter<?>> getters = new HashMap();

    public JsonTypedArray(Json.Array array, Class<T> type) {
        this.array = array;
        Getter<?> getter = getters.get(type);
        if (getter == null) {
            throw new IllegalArgumentException("Only json types may be used for TypedArray, not '" + type.getName() + "'");
        }
        this.getter = getter;
    }

    @Override
    public int length() {
        return this.array.length();
    }

    @Override
    public T get(int index) {
        return this.getter.get(this.array, index, null);
    }

    @Override
    public T get(int index, T dflt) {
        return this.getter.get(this.array, index, dflt);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < JsonTypedArray.this.length();
            }

            @Override
            public T next() {
                if (this.index >= JsonTypedArray.this.length()) {
                    throw new NoSuchElementException();
                }
                return JsonTypedArray.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        getters.put(Boolean.class, new Getter<Boolean>(){

            @Override
            public Boolean get(Json.Array array, int index, Boolean dflt) {
                return dflt == null ? array.getBoolean(index) : array.getBoolean(index, dflt);
            }
        });
        getters.put(Integer.class, new Getter<Integer>(){

            @Override
            public Integer get(Json.Array array, int index, Integer dflt) {
                return dflt == null ? array.getInt(index) : array.getInt(index, dflt);
            }
        });
        getters.put(Double.class, new Getter<Double>(){

            @Override
            public Double get(Json.Array array, int index, Double dflt) {
                return dflt == null ? array.getDouble(index) : array.getDouble(index, dflt);
            }
        });
        getters.put(Float.class, new Getter<Float>(){

            @Override
            public Float get(Json.Array array, int index, Float dflt) {
                return Float.valueOf(dflt == null ? array.getNumber(index) : array.getNumber(index, dflt.floatValue()));
            }
        });
        getters.put(String.class, new Getter<String>(){

            @Override
            public String get(Json.Array array, int index, String dflt) {
                return array.getString(index, dflt);
            }
        });
        getters.put(Json.Array.class, new Getter<Json.Array>(){

            @Override
            public Json.Array get(Json.Array array, int index, Json.Array dflt) {
                return array.getArray(index, dflt);
            }
        });
        getters.put(Json.Object.class, new Getter<Json.Object>(){

            @Override
            public Json.Object get(Json.Array array, int index, Json.Object dflt) {
                return array.getObject(index, dflt);
            }
        });
    }

    private static interface Getter<T> {
        public T get(Json.Array var1, int var2, T var3);
    }
}

