/*
 * Decompiled with CFR 0.152.
 */
package playn.core.json;

import playn.core.Json;
import playn.core.json.JsonArray;
import playn.core.json.JsonObject;
import playn.core.json.JsonParser;
import playn.core.json.JsonParserException;
import playn.core.json.JsonStringWriter;
import playn.core.json.JsonTypes;

public class JsonImpl
implements Json {
    @Override
    public Json.Writer newWriter() {
        return new JsonStringWriter();
    }

    @Override
    public Json.Array createArray() {
        return new JsonArray();
    }

    @Override
    public Json.Object createObject() {
        return new JsonObject();
    }

    @Override
    public boolean isArray(Object o) {
        return JsonTypes.isArray(o);
    }

    @Override
    public boolean isObject(Object o) {
        return JsonTypes.isObject(o);
    }

    @Override
    public Json.Object parse(String json) throws JsonParserException {
        return JsonParser.object().from(json);
    }

    @Override
    public Json.Array parseArray(String json) throws JsonParserException {
        return JsonParser.array().from(json);
    }

    static void checkJsonType(Object value) {
        if (value == null || value instanceof String || value instanceof Json.Object || value instanceof Json.Array || value instanceof Boolean || value instanceof Number) {
            return;
        }
        throw new IllegalArgumentException("Invalid JSON type [value=" + value + ", class=" + value.getClass() + "]");
    }
}

