/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.GL20;
import playn.core.GLProgram;
import playn.core.QuadBatch;
import playn.core.Texture;
import playn.core.TexturedBatch;
import pythagoras.f.AffineTransform;

public class TriangleBatch
extends QuadBatch {
    private static final int START_VERTS = 64;
    private static final int EXPAND_VERTS = 64;
    private static final int START_ELEMS = 96;
    private static final int EXPAND_ELEMS = 96;
    private static final int FLOAT_SIZE_BYTES = 4;
    private final boolean delayedBinding;
    protected final GLProgram program;
    protected final int uTexture;
    protected final int uHScreenSize;
    protected final int uFlip;
    protected final int aMatrix;
    protected final int aTranslation;
    protected final int aColor;
    protected final int aPosition;
    protected final int aTexCoord;
    protected final int verticesId;
    protected final int elementsId;
    protected final float[] stableAttrs;
    protected float[] vertices;
    protected short[] elements;
    protected int vertPos;
    protected int elemPos;
    protected static final int[] QUAD_INDICES = new int[]{0, 1, 2, 1, 3, 2};

    public TriangleBatch(GL20 gl) {
        this(gl, new Source());
    }

    public TriangleBatch(GL20 gl, Source source) {
        super(gl);
        this.delayedBinding = "Intel".equals(gl.glGetString(7936));
        this.program = new GLProgram(gl, source.vertex(), source.fragment());
        this.uTexture = this.program.getUniformLocation("u_Texture");
        this.uHScreenSize = this.program.getUniformLocation("u_HScreenSize");
        this.uFlip = this.program.getUniformLocation("u_Flip");
        this.aMatrix = this.program.getAttribLocation("a_Matrix");
        this.aTranslation = this.program.getAttribLocation("a_Translation");
        this.aColor = this.program.getAttribLocation("a_Color");
        this.aPosition = this.program.getAttribLocation("a_Position");
        this.aTexCoord = this.program.getAttribLocation("a_TexCoord");
        this.stableAttrs = new float[this.stableAttrsSize()];
        this.vertices = new float[64 * this.vertexSize()];
        this.elements = new short[96];
        int[] ids = new int[2];
        gl.glGenBuffers(2, ids, 0);
        this.verticesId = ids[0];
        this.elementsId = ids[1];
        gl.checkError("TriangleBatch end ctor");
    }

    public void prepare(int tint, AffineTransform xf) {
        this.prepare(tint, xf.m00, xf.m01, xf.m10, xf.m11, xf.tx, xf.ty);
    }

    public void prepare(int tint, float m00, float m01, float m10, float m11, float tx, float ty) {
        float[] stables = this.stableAttrs;
        stables[0] = m00;
        stables[1] = m01;
        stables[2] = m10;
        stables[3] = m11;
        stables[4] = tx;
        stables[5] = ty;
        stables[6] = tint >> 16 & 0xFFFF;
        stables[7] = tint >> 0 & 0xFFFF;
        this.addExtraStableAttrs(stables, 8);
    }

    public void addTris(Texture tex, int tint, AffineTransform xf, float[] xys, int xysOffset, int xysLen, float tw, float th, int[] indices, int indicesOffset, int indicesLen, int indexBase) {
        this.setTexture(tex);
        this.prepare(tint, xf);
        this.addTris(xys, xysOffset, xysLen, tw, th, indices, indicesOffset, indicesLen, indexBase);
    }

    public void addTris(Texture tex, int tint, AffineTransform xf, float[] xys, float[] sxys, int xysOffset, int xysLen, int[] indices, int indicesOffset, int indicesLen, int indexBase) {
        this.setTexture(tex);
        this.prepare(tint, xf);
        this.addTris(xys, sxys, xysOffset, xysLen, indices, indicesOffset, indicesLen, indexBase);
    }

    public void addTris(float[] xys, int xysOffset, int xysLen, float tw, float th, int[] indices, int indicesOffset, int indicesLen, int indexBase) {
        int ii;
        int vertIdx = this.beginPrimitive(xysLen / 2, indicesLen);
        int offset = this.vertPos;
        float[] verts = this.vertices;
        float[] stables = this.stableAttrs;
        int ll = ii + xysLen;
        for (ii = xysOffset; ii < ll; ii += 2) {
            float x = xys[ii];
            float y = xys[ii + 1];
            offset = TriangleBatch.add(verts, TriangleBatch.add(verts, offset, stables), x, y, x / tw, y / th);
        }
        this.vertPos = offset;
        this.addElems(vertIdx, indices, indicesOffset, indicesLen, indexBase);
    }

    public void addTris(float[] xys, float[] sxys, int xysOffset, int xysLen, int[] indices, int indicesOffset, int indicesLen, int indexBase) {
        int ii;
        int vertIdx = this.beginPrimitive(xysLen / 2, indicesLen);
        int offset = this.vertPos;
        float[] verts = this.vertices;
        float[] stables = this.stableAttrs;
        int ll = ii + xysLen;
        for (ii = xysOffset; ii < ll; ii += 2) {
            offset = TriangleBatch.add(verts, TriangleBatch.add(verts, offset, stables), xys[ii], xys[ii + 1], sxys[ii], sxys[ii + 1]);
        }
        this.vertPos = offset;
        this.addElems(vertIdx, indices, indicesOffset, indicesLen, indexBase);
    }

    @Override
    public void addQuad(int tint, float m00, float m01, float m10, float m11, float tx, float ty, float x1, float y1, float sx1, float sy1, float x2, float y2, float sx2, float sy2, float x3, float y3, float sx3, float sy3, float x4, float y4, float sx4, float sy4) {
        this.prepare(tint, m00, m01, m10, m11, tx, ty);
        int vertIdx = this.beginPrimitive(4, 6);
        int offset = this.vertPos;
        float[] verts = this.vertices;
        float[] stables = this.stableAttrs;
        offset = TriangleBatch.add(verts, TriangleBatch.add(verts, offset, stables), x1, y1, sx1, sy1);
        offset = TriangleBatch.add(verts, TriangleBatch.add(verts, offset, stables), x2, y2, sx2, sy2);
        offset = TriangleBatch.add(verts, TriangleBatch.add(verts, offset, stables), x3, y3, sx3, sy3);
        this.vertPos = offset = TriangleBatch.add(verts, TriangleBatch.add(verts, offset, stables), x4, y4, sx4, sy4);
        this.addElems(vertIdx, QUAD_INDICES, 0, QUAD_INDICES.length, 0);
    }

    @Override
    public void begin(float fbufWidth, float fbufHeight, boolean flip) {
        super.begin(fbufWidth, fbufHeight, flip);
        this.program.activate();
        this.gl.glUniform2f(this.uHScreenSize, fbufWidth / 2.0f, fbufHeight / 2.0f);
        this.gl.glUniform1f(this.uFlip, flip ? -1.0f : 1.0f);
        if (!this.delayedBinding) {
            this.bindAttribsBufs();
        }
        this.gl.checkError("TriangleBatch begin");
    }

    private void bindAttribsBufs() {
        this.gl.glBindBuffer(34962, this.verticesId);
        int stride = this.vertexStride();
        this.glBindVertAttrib(this.aMatrix, 4, 5126, stride, 0);
        this.glBindVertAttrib(this.aTranslation, 2, 5126, stride, 16);
        this.glBindVertAttrib(this.aColor, 2, 5126, stride, 24);
        int offset = this.stableAttrsSize() * 4;
        this.glBindVertAttrib(this.aPosition, 2, 5126, stride, offset);
        this.glBindVertAttrib(this.aTexCoord, 2, 5126, stride, offset + 8);
        this.gl.glBindBuffer(34963, this.elementsId);
        this.gl.glActiveTexture(33984);
        this.gl.glUniform1i(this.uTexture, 0);
    }

    @Override
    public void flush() {
        super.flush();
        if (this.vertPos > 0) {
            this.bindTexture();
            if (this.delayedBinding) {
                this.bindAttribsBufs();
                this.gl.checkError("TriangleBatch.flush bind");
            }
            this.gl.bufs.setFloatBuffer(this.vertices, 0, this.vertPos);
            this.gl.glBufferData(34962, this.vertPos * 4, this.gl.bufs.floatBuffer, 35040);
            this.gl.bufs.setShortBuffer(this.elements, 0, this.elemPos);
            this.gl.glBufferData(34963, this.elemPos * 2, this.gl.bufs.shortBuffer, 35040);
            this.gl.checkError("TriangleBatch.flush BufferData");
            this.gl.glDrawElements(4, this.elemPos, 5123, 0);
            this.gl.checkError("TriangleBatch.flush DrawElements");
            this.vertPos = 0;
            this.elemPos = 0;
        }
    }

    @Override
    public void end() {
        super.end();
        this.gl.glDisableVertexAttribArray(this.aMatrix);
        this.gl.glDisableVertexAttribArray(this.aTranslation);
        this.gl.glDisableVertexAttribArray(this.aColor);
        this.gl.glDisableVertexAttribArray(this.aPosition);
        this.gl.glDisableVertexAttribArray(this.aTexCoord);
        this.gl.checkError("TriangleBatch end");
    }

    @Override
    public void close() {
        super.close();
        this.program.close();
        this.gl.glDeleteBuffers(2, new int[]{this.verticesId, this.elementsId}, 0);
        this.gl.checkError("TriangleBatch close");
    }

    public String toString() {
        return "tris/" + this.elements.length / QUAD_INDICES.length;
    }

    protected int stableAttrsSize() {
        return 8;
    }

    protected int vertexSize() {
        return this.stableAttrsSize() + 4;
    }

    protected int vertexStride() {
        return this.vertexSize() * 4;
    }

    protected int addExtraStableAttrs(float[] buf, int sidx) {
        return sidx;
    }

    protected int beginPrimitive(int vertexCount, int elemCount) {
        int vertIdx = this.vertPos / this.vertexSize();
        int verts = vertIdx + vertexCount;
        int elems = this.elemPos + elemCount;
        int availVerts = this.vertices.length / this.vertexSize();
        int availElems = this.elements.length;
        if (verts <= availVerts && elems <= availElems) {
            return vertIdx;
        }
        this.flush();
        if (verts > availVerts) {
            this.expandVerts(verts);
        }
        if (elems > availElems) {
            this.expandElems(elems);
        }
        return 0;
    }

    protected final void glBindVertAttrib(int loc, int size, int type, int stride, int offset) {
        this.gl.glEnableVertexAttribArray(loc);
        this.gl.glVertexAttribPointer(loc, size, type, false, stride, offset);
    }

    protected final void addElems(int vertIdx, int[] indices, int indicesOffset, int indicesLen, int indexBase) {
        int ii;
        short[] data = this.elements;
        int offset = this.elemPos;
        int ll = ii + indicesLen;
        for (ii = indicesOffset; ii < ll; ++ii) {
            data[offset++] = (short)(vertIdx + indices[ii] - indexBase);
        }
        this.elemPos = offset;
    }

    private final void expandVerts(int vertCount) {
        int newVerts;
        for (newVerts = this.vertices.length / this.vertexSize(); newVerts < vertCount; newVerts += 64) {
        }
        this.vertices = new float[newVerts * this.vertexSize()];
    }

    private final void expandElems(int elemCount) {
        int newElems;
        for (newElems = this.elements.length; newElems < elemCount; newElems += 96) {
        }
        this.elements = new short[newElems];
    }

    protected static int add(float[] into, int offset, float[] stables) {
        System.arraycopy(stables, 0, into, offset, stables.length);
        return offset + stables.length;
    }

    protected static int add(float[] into, int offset, float[] stables, int soff, int slen) {
        System.arraycopy(stables, soff, into, offset, slen);
        return offset + slen;
    }

    protected static int add(float[] into, int offset, float x, float y, float sx, float sy) {
        into[offset++] = x;
        into[offset++] = y;
        into[offset++] = sx;
        into[offset++] = sy;
        return offset;
    }

    public static class Source
    extends TexturedBatch.Source {
        public static final String VERT_UNIFS = "uniform vec2 u_HScreenSize;\nuniform float u_Flip;\n";
        public static final String VERT_ATTRS = "attribute vec4 a_Matrix;\nattribute vec2 a_Translation;\nattribute vec2 a_Color;\n";
        public static final String PER_VERT_ATTRS = "attribute vec2 a_Position;\nattribute vec2 a_TexCoord;\n";
        public static final String VERT_VARS = "varying vec2 v_TexCoord;\nvarying vec4 v_Color;\n";
        public static final String VERT_SETPOS = "mat3 transform = mat3(\n  a_Matrix[0],      a_Matrix[1],      0,\n  a_Matrix[2],      a_Matrix[3],      0,\n  a_Translation[0], a_Translation[1], 1);\ngl_Position = vec4(transform * vec3(a_Position, 1.0), 1);\ngl_Position.xy /= u_HScreenSize.xy;\ngl_Position.xy -= 1.0;\ngl_Position.y *= u_Flip;\n";
        public static final String VERT_SETTEX = "v_TexCoord = a_TexCoord;\n";
        public static final String VERT_SETCOLOR = "float red = mod(a_Color.x, 256.0);\nfloat alpha = (a_Color.x - red) / 256.0;\nfloat blue = mod(a_Color.y, 256.0);\nfloat green = (a_Color.y - blue) / 256.0;\nv_Color = vec4(red / 255.0, green / 255.0, blue / 255.0, alpha / 255.0);\n";

        public String vertex() {
            return "uniform vec2 u_HScreenSize;\nuniform float u_Flip;\nattribute vec4 a_Matrix;\nattribute vec2 a_Translation;\nattribute vec2 a_Color;\nattribute vec2 a_Position;\nattribute vec2 a_TexCoord;\nvarying vec2 v_TexCoord;\nvarying vec4 v_Color;\nvoid main(void) {\nmat3 transform = mat3(\n  a_Matrix[0],      a_Matrix[1],      0,\n  a_Matrix[2],      a_Matrix[3],      0,\n  a_Translation[0], a_Translation[1], 1);\ngl_Position = vec4(transform * vec3(a_Position, 1.0), 1);\ngl_Position.xy /= u_HScreenSize.xy;\ngl_Position.xy -= 1.0;\ngl_Position.y *= u_Flip;\nv_TexCoord = a_TexCoord;\nfloat red = mod(a_Color.x, 256.0);\nfloat alpha = (a_Color.x - red) / 256.0;\nfloat blue = mod(a_Color.y, 256.0);\nfloat green = (a_Color.y - blue) / 256.0;\nv_Color = vec4(red / 255.0, green / 255.0, blue / 255.0, alpha / 255.0);\n}";
        }
    }
}

