/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.GL20;
import playn.core.GLBatch;
import playn.core.Texture;

public class TexturedBatch
extends GLBatch {
    public final GL20 gl;
    protected int curTexId;

    public void setTexture(Texture texture) {
        if (this.curTexId != 0 && this.curTexId != texture.id) {
            this.flush();
        }
        this.curTexId = texture.id;
    }

    @Override
    public void end() {
        super.end();
        this.curTexId = 0;
    }

    protected TexturedBatch(GL20 gl) {
        this.gl = gl;
    }

    protected void bindTexture() {
        this.gl.glBindTexture(3553, this.curTexId);
        this.gl.checkError("QuadBatch glBindTexture");
    }

    public static abstract class Source {
        protected static final String FRAGMENT_PREAMBLE = "#ifdef GL_ES\nprecision lowp float;\n#else\n#define lowp\n#define mediump\n#define highp\n#endif\n";

        public String fragment() {
            StringBuilder str = new StringBuilder(FRAGMENT_PREAMBLE);
            str.append(this.textureUniforms());
            str.append(this.textureVaryings());
            str.append("void main(void) {\n");
            str.append(this.textureColor());
            str.append(this.textureTint());
            str.append(this.textureAlpha());
            str.append("  gl_FragColor = textureColor;\n}");
            return str.toString();
        }

        protected String textureUniforms() {
            return "uniform lowp sampler2D u_Texture;\n";
        }

        protected String textureVaryings() {
            return "varying mediump vec2 v_TexCoord;\nvarying lowp vec4 v_Color;\n";
        }

        protected String textureColor() {
            return "  vec4 textureColor = texture2D(u_Texture, v_TexCoord);\n";
        }

        protected String textureTint() {
            return "  textureColor.rgb *= v_Color.rgb;\n";
        }

        protected String textureAlpha() {
            return "  textureColor *= v_Color.a;\n";
        }
    }
}

