/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.TextFormat;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import pythagoras.f.IRectangle;

public abstract class TextLayout {
    public final String text;
    public final TextFormat format;
    public final IRectangle bounds;
    public final IDimension size;

    public abstract float ascent();

    public abstract float descent();

    public abstract float leading();

    protected TextLayout(String text, TextFormat format, IRectangle bounds, float height) {
        this.text = text;
        this.format = format;
        this.bounds = bounds;
        this.size = new Dimension(Math.max(bounds.x(), 0.0f) + bounds.width(), height);
    }

    public static String normalizeEOL(String text) {
        return text.replace("\r\n", "\n").replace('\r', '\n');
    }
}

