/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Canvas;
import playn.core.Graphics;
import playn.core.TextLayout;
import pythagoras.f.IRectangle;
import pythagoras.f.Rectangle;

public class TextBlock {
    public final TextLayout[] lines;
    public final IRectangle bounds;

    public static Rectangle getBounds(TextLayout[] lines, Rectangle into) {
        float xAdjust = 0.0f;
        float twidth = 0.0f;
        float theight = 0.0f;
        for (TextLayout layout : lines) {
            IRectangle bounds = layout.bounds;
            xAdjust = Math.max(xAdjust, -Math.min(0.0f, bounds.x()));
            twidth = Math.max(twidth, layout.size.width());
            if (layout != lines[0]) {
                theight += layout.leading();
            }
            theight += layout.ascent() + layout.descent();
        }
        into.setBounds(xAdjust, 0.0f, xAdjust + twidth, theight);
        return into;
    }

    public TextBlock(TextLayout[] lines) {
        this.lines = lines;
        this.bounds = TextBlock.getBounds(lines, new Rectangle());
    }

    public float textWidth() {
        return this.bounds.width() - this.bounds.x();
    }

    public void fill(Canvas canvas, Align align, float x, float y) {
        float sy = y + this.bounds.y();
        for (TextLayout line : this.lines) {
            float sx = x + this.bounds.x() + align.getX(line.size.width(), this.textWidth());
            canvas.fillText(line, sx, sy);
            sy += line.ascent() + line.descent() + line.leading();
        }
    }

    public void stroke(Canvas canvas, Align align, float x, float y) {
        float sy = y + this.bounds.y();
        for (TextLayout line : this.lines) {
            float sx = x + this.bounds.x() + align.getX(line.size.width(), this.textWidth());
            canvas.strokeText(line, sx, sy);
            sy += line.ascent() + line.descent() + line.leading();
        }
    }

    public Canvas toCanvas(Graphics gfx, Align align, int fillColor) {
        float pad = 1.0f / gfx.scale().factor;
        Canvas canvas = gfx.createCanvas(this.bounds.width() + 2.0f * pad, this.bounds.height() + 2.0f * pad);
        canvas.setFillColor(fillColor);
        this.fill(canvas, align, pad, pad);
        return canvas;
    }

    public static enum Align {
        LEFT{

            @Override
            public float getX(float lineWidth, float blockWidth) {
                return 0.0f;
            }
        }
        ,
        CENTER{

            @Override
            public float getX(float lineWidth, float blockWidth) {
                return (blockWidth - lineWidth) / 2.0f;
            }
        }
        ,
        RIGHT{

            @Override
            public float getX(float lineWidth, float blockWidth) {
                return blockWidth - lineWidth;
            }
        };


        public abstract float getX(float var1, float var2);
    }
}

