/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

public abstract class Log {
    private Collector collector;
    private Level minLevel = Level.DEBUG;

    public static StringBuilder format(StringBuilder into, Object ... args) {
        int ll = args.length / 2;
        for (int ii = 0; ii < ll; ++ii) {
            if (ii > 0) {
                into.append(", ");
            }
            into.append(args[2 * ii]).append("=").append(args[2 * ii + 1]);
        }
        return into;
    }

    public void setCollector(Collector collector) {
        this.collector = collector;
    }

    public void setMinLevel(Level level) {
        assert (level != null);
        this.minLevel = level;
    }

    public void debug(String msg) {
        this.debug(msg, null);
    }

    public void debug(String msg, Object ... args) {
        this.debug(this.format(msg, args), this.getCause(args));
    }

    public void debug(String msg, Throwable e) {
        this.log(Level.DEBUG, msg, e);
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String msg, Object ... args) {
        this.info(this.format(msg, args), this.getCause(args));
    }

    public void info(String msg, Throwable e) {
        this.log(Level.INFO, msg, e);
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Object ... args) {
        this.warn(this.format(msg, args), this.getCause(args));
    }

    public void warn(String msg, Throwable e) {
        this.log(Level.WARN, msg, e);
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Object ... args) {
        this.error(this.format(msg, args), this.getCause(args));
    }

    public void error(String msg, Throwable e) {
        this.log(Level.ERROR, msg, e);
    }

    protected String format(String msg, Object[] args) {
        return Log.format(new StringBuilder().append(msg).append(" ["), args).append("]").toString();
    }

    protected void log(Level level, String msg, Throwable e) {
        if (this.collector != null) {
            this.collector.logged(level, msg, e);
        }
        if (level.ordinal() >= this.minLevel.ordinal()) {
            this.logImpl(level, msg, e);
        }
    }

    private Throwable getCause(Object[] args) {
        int acount = args.length;
        return acount % 2 == 1 && args[acount - 1] instanceof Throwable ? (Throwable)args[acount - 1] : null;
    }

    protected abstract void logImpl(Level var1, String var2, Throwable var3);

    public static interface Collector {
        public void logged(Level var1, String var2, Throwable var3);
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

