/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Canvas;
import playn.core.Graphics;
import playn.core.Pattern;
import playn.core.Scale;
import playn.core.Texture;
import playn.core.Tile;
import playn.core.TileSource;
import react.Closeable;
import react.Function;
import react.RFuture;
import react.Try;

public abstract class Image
extends TileSource
implements Canvas.Drawable,
Closeable {
    public final RFuture<Image> state;
    protected final Graphics gfx;
    protected Texture.Config texconf = Texture.Config.DEFAULT;
    protected Texture texture;

    @Override
    public boolean isLoaded() {
        Try cur = this.state.result();
        return cur != null && cur.isSuccess();
    }

    public abstract Scale scale();

    @Override
    public float width() {
        return this.scale().invScaled(this.pixelWidth());
    }

    @Override
    public float height() {
        return this.scale().invScaled(this.pixelHeight());
    }

    public abstract int pixelWidth();

    public abstract int pixelHeight();

    public abstract void getRgb(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7);

    public abstract void setRgb(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7);

    public abstract Pattern createPattern(boolean var1, boolean var2);

    public Image setConfig(Texture.Config config) {
        this.texconf = config;
        return this;
    }

    public Texture texture() {
        if (this.texture == null || this.texture.disposed()) {
            this.texture = this.createTexture(this.texconf);
        }
        return this.texture;
    }

    public Texture updateTexture() {
        if (this.texture == null || this.texture.disposed()) {
            this.texture = this.createTexture(this.texconf);
        } else {
            this.texture.update(this);
        }
        return this.texture;
    }

    public RFuture<Texture> textureAsync() {
        return this.state.map((Function)new Function<Image, Texture>(){

            public Texture apply(Image image) {
                return Image.this.texture();
            }
        });
    }

    public Texture createTexture(Texture.Config config) {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Cannot create texture from unready image: " + this);
        }
        int texWidth = config.toTexWidth(this.pixelWidth());
        int texHeight = config.toTexHeight(this.pixelHeight());
        if (texWidth <= 0 || texHeight <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + texWidth + "x" + texHeight + " from: " + this);
        }
        Texture tex = new Texture(this.gfx, this.gfx.createTexture(config), config, texWidth, texHeight, this.scale(), this.width(), this.height());
        tex.update(this);
        return tex;
    }

    public void close() {
        if (this.texture != null) {
            this.texture.close();
        }
    }

    public Region region(final float rx, final float ry, final float rwidth, final float rheight) {
        final Image image = this;
        return new Region(){
            private Tile tile;

            @Override
            public boolean isLoaded() {
                return image.isLoaded();
            }

            @Override
            public Tile tile() {
                if (this.tile == null) {
                    this.tile = image.texture().tile(rx, ry, rwidth, rheight);
                }
                return this.tile;
            }

            @Override
            public RFuture<Tile> tileAsync() {
                return image.state.map((Function)new Function<Image, Tile>(){

                    public Tile apply(Image image) {
                        return this.tile();
                    }
                });
            }

            @Override
            public float width() {
                return rwidth;
            }

            @Override
            public float height() {
                return rheight;
            }

            @Override
            public void draw(Object ctx, float x, float y, float width, float height) {
                image.draw(ctx, x, y, width, height, rx, ry, rwidth, rheight);
            }

            @Override
            public void draw(Object ctx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
                image.draw(ctx, dx, dy, dw, dh, rx + sx, ry + sy, sw, sh);
            }
        };
    }

    public abstract Image transform(BitmapTransformer var1);

    @Override
    public Tile tile() {
        return this.texture();
    }

    @Override
    public RFuture<Tile> tileAsync() {
        return this.state.map((Function)new Function<Image, Tile>(){

            public Tile apply(Image image) {
                return Image.this.texture();
            }
        });
    }

    protected Image(Graphics gfx, RFuture<Image> state) {
        this.gfx = gfx;
        this.state = state;
    }

    protected Image(Graphics gfx) {
        this.gfx = gfx;
        this.state = RFuture.success((Object)this);
    }

    protected abstract void upload(Graphics var1, Texture var2);

    public static interface BitmapTransformer {
    }

    public static abstract class Region
    extends TileSource
    implements Canvas.Drawable {
    }
}

