/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Canvas;
import playn.core.Exec;
import playn.core.GL20;
import playn.core.Gradient;
import playn.core.Path;
import playn.core.Platform;
import playn.core.RenderTarget;
import playn.core.Scale;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.core.Texture;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import react.Function;
import react.Value;
import react.ValueView;

public abstract class Graphics {
    protected final Platform plat;
    protected final Dimension viewSizeM = new Dimension();
    protected final Value<OrientationDetail> orientDetailM = Value.create((Object)((Object)OrientationDetail.UNKNOWN));
    private Scale scale;
    private int viewPixelWidth;
    private int viewPixelHeight;
    private Texture colorTex;
    public final GL20 gl;
    public final IDimension viewSize = this.viewSizeM;
    public final ValueView<Orientation> deviceOrient = this.orientDetailM.map((Function)new Function<OrientationDetail, Orientation>(){

        public Orientation apply(OrientationDetail detail) {
            switch (detail) {
                case LANDSCAPE_LEFT: {
                    return Orientation.LANDSCAPE;
                }
                case LANDSCAPE_RIGHT: {
                    return Orientation.LANDSCAPE;
                }
            }
            return Orientation.PORTRAIT;
        }
    });
    public final ValueView<OrientationDetail> orientDetail = this.orientDetailM;
    public RenderTarget defaultRenderTarget = new RenderTarget(this){

        @Override
        public int id() {
            return Graphics.this.defaultFramebuffer();
        }

        @Override
        public int width() {
            return Graphics.this.viewPixelWidth;
        }

        @Override
        public int height() {
            return Graphics.this.viewPixelHeight;
        }

        @Override
        public float xscale() {
            return ((Graphics)Graphics.this).scale.factor;
        }

        @Override
        public float yscale() {
            return ((Graphics)Graphics.this).scale.factor;
        }

        @Override
        public boolean flip() {
            return true;
        }

        @Override
        public void close() {
        }
    };

    public Scale scale() {
        return this.scale;
    }

    public abstract IDimension screenSize();

    public Canvas createCanvas(float width, float height) {
        return this.createCanvasImpl(this.scale, this.scale.scaledCeil(width), this.scale.scaledCeil(height));
    }

    public Canvas createCanvas(IDimension size) {
        return this.createCanvas(size.width(), size.height());
    }

    public abstract Path createPath();

    public abstract Gradient createGradient(Gradient.Config var1);

    public Texture createTexture(float width, float height, Texture.Config config) {
        int texWidth = config.toTexWidth(this.scale.scaledCeil(width));
        int texHeight = config.toTexHeight(this.scale.scaledCeil(height));
        if (texWidth <= 0 || texHeight <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + texWidth + "x" + texHeight);
        }
        int id = this.createTexture(config);
        this.gl.glTexImage2D(3553, 0, 6408, texWidth, texHeight, 0, 6408, 5121, null);
        return new Texture(this, id, config, texWidth, texHeight, this.scale, width, height);
    }

    public Texture createTexture(IDimension size, Texture.Config config) {
        return this.createTexture(size.width(), size.height(), config);
    }

    public abstract TextLayout layoutText(String var1, TextFormat var2);

    public abstract TextLayout[] layoutText(String var1, TextFormat var2, TextWrap var3);

    Exec exec() {
        return this.plat.exec();
    }

    Texture colorTex() {
        if (this.colorTex == null) {
            Canvas canvas = this.createCanvas(1.0f, 1.0f);
            canvas.setFillColor(-1).fillRect(0.0f, 0.0f, canvas.width, canvas.height);
            this.colorTex = canvas.toTexture(Texture.Config.UNMANAGED);
        }
        return this.colorTex;
    }

    protected Graphics(Platform plat, GL20 gl, Scale scale) {
        this.plat = plat;
        this.gl = gl;
        this.scale = scale;
    }

    protected int defaultFramebuffer() {
        return 0;
    }

    protected abstract Canvas createCanvasImpl(Scale var1, int var2, int var3);

    protected void scaleChanged(Scale scale) {
        this.scale = scale;
    }

    protected void viewportChanged(int pixelWidth, int pixelHeight) {
        this.viewPixelWidth = pixelWidth;
        this.viewPixelHeight = pixelHeight;
        this.viewSizeM.width = this.scale.invScaled(pixelWidth);
        this.viewSizeM.height = this.scale.invScaled(pixelHeight);
        this.plat.log().info("viewPortChanged " + pixelWidth + "x" + pixelHeight + " / " + this.scale.factor + " -> " + this.viewSize);
    }

    int createTexture(Texture.Config config) {
        int id = this.gl.glGenTexture();
        this.gl.glBindTexture(3553, id);
        this.gl.glTexParameteri(3553, 10240, config.magFilter);
        int minFilter = Graphics.mipmapify(config.minFilter, config.mipmaps);
        this.gl.glTexParameteri(3553, 10241, minFilter);
        this.gl.glTexParameteri(3553, 10242, config.repeatX ? 10497 : 33071);
        this.gl.glTexParameteri(3553, 10243, config.repeatY ? 10497 : 33071);
        return id;
    }

    protected static int mipmapify(int filter, boolean mipmaps) {
        if (!mipmaps) {
            return filter;
        }
        switch (filter) {
            case 9728: {
                return 9984;
            }
            case 9729: {
                return 9985;
            }
        }
        return filter;
    }

    public static enum Orientation {
        PORTRAIT,
        LANDSCAPE;

    }

    public static enum OrientationDetail {
        UNKNOWN,
        PORTRAIT,
        PORTRAIT_UPSIDE_DOWN,
        LANDSCAPE_LEFT,
        LANDSCAPE_RIGHT,
        FACE_UP,
        FACE_DOWN;

    }
}

