/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class GL20 {
    public static final int GL_ACTIVE_TEXTURE = 34016;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DITHER = 3024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public static final int GL_SAMPLE_COVERAGE = 32928;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_SAMPLE_BUFFERS = 32936;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_SAMPLE_COVERAGE_VALUE = 32938;
    public static final int GL_SAMPLE_COVERAGE_INVERT = 32939;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS = 34467;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FIXED = 5132;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_BGRA = 32993;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_UNSIGNED_INT_8_8_8_8 = 32821;
    public static final int GL_UNSIGNED_INT_8_8_8_8_REV = 33639;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_INVERT = 5386;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_TEXTURE_CUBE_MAP = 34067;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP = 34068;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public static final int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE4 = 33988;
    public static final int GL_TEXTURE5 = 33989;
    public static final int GL_TEXTURE6 = 33990;
    public static final int GL_TEXTURE7 = 33991;
    public static final int GL_TEXTURE8 = 33992;
    public static final int GL_TEXTURE9 = 33993;
    public static final int GL_TEXTURE10 = 33994;
    public static final int GL_TEXTURE11 = 33995;
    public static final int GL_TEXTURE12 = 33996;
    public static final int GL_TEXTURE13 = 33997;
    public static final int GL_TEXTURE14 = 33998;
    public static final int GL_TEXTURE15 = 33999;
    public static final int GL_TEXTURE16 = 34000;
    public static final int GL_TEXTURE17 = 34001;
    public static final int GL_TEXTURE18 = 34002;
    public static final int GL_TEXTURE19 = 34003;
    public static final int GL_TEXTURE20 = 34004;
    public static final int GL_TEXTURE21 = 34005;
    public static final int GL_TEXTURE22 = 34006;
    public static final int GL_TEXTURE23 = 34007;
    public static final int GL_TEXTURE24 = 34008;
    public static final int GL_TEXTURE25 = 34009;
    public static final int GL_TEXTURE26 = 34010;
    public static final int GL_TEXTURE27 = 34011;
    public static final int GL_TEXTURE28 = 34012;
    public static final int GL_TEXTURE29 = 34013;
    public static final int GL_TEXTURE30 = 34014;
    public static final int GL_TEXTURE31 = 34015;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGB565 = 36194;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_NONE = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;
    public final Buffers bufs;
    public final boolean checkErrors;

    protected GL20(Buffers buffers, boolean checkErrors) {
        this.bufs = buffers;
        this.checkErrors = checkErrors;
    }

    public boolean checkError(String op) {
        int reported = 0;
        if (this.checkErrors) {
            int error;
            while ((error = this.glGetError()) != 0) {
                ++reported;
                System.err.println(op + ": glError " + error);
            }
        }
        return reported > 0;
    }

    public void glDeleteBuffer(int id) {
        this.bufs.setIntBuffer(id);
        this.glDeleteBuffers(1, this.bufs.intBuffer);
    }

    public void glDeleteBuffers(int n, int[] buffers, int offset) {
        this.bufs.setIntBuffer(buffers, offset, n);
        this.glDeleteBuffers(n, this.bufs.intBuffer);
    }

    public void glDeleteFramebuffer(int id) {
        this.bufs.setIntBuffer(id);
        this.glDeleteFramebuffers(1, this.bufs.intBuffer);
    }

    public void glDeleteFramebuffers(int n, int[] framebuffers, int offset) {
        this.bufs.setIntBuffer(framebuffers, offset, n);
        this.glDeleteFramebuffers(n, this.bufs.intBuffer);
    }

    public void glDeleteRenderbuffer(int id) {
        this.bufs.setIntBuffer(id);
        this.glDeleteRenderbuffers(1, this.bufs.intBuffer);
    }

    public void glDeleteRenderbuffers(int n, int[] renderbuffers, int offset) {
        this.bufs.setIntBuffer(renderbuffers, offset, n);
        this.glDeleteRenderbuffers(n, this.bufs.intBuffer);
    }

    public void glDeleteTexture(int id) {
        this.bufs.setIntBuffer(id);
        this.glDeleteTextures(1, this.bufs.intBuffer);
    }

    public void glDeleteTextures(int n, int[] textures, int offset) {
        this.bufs.setIntBuffer(textures, offset, n);
        this.glDeleteTextures(n, this.bufs.intBuffer);
    }

    public int glGenBuffer() {
        this.bufs.resizeIntBuffer(1);
        this.glGenBuffers(1, this.bufs.intBuffer);
        return this.bufs.intBuffer.get(0);
    }

    public void glGenBuffers(int n, int[] buffers, int offset) {
        this.bufs.resizeIntBuffer(n);
        this.glGenBuffers(n, this.bufs.intBuffer);
        this.bufs.intBuffer.get(buffers, offset, n);
    }

    public int glGenFramebuffer() {
        this.bufs.resizeIntBuffer(1);
        this.glGenFramebuffers(1, this.bufs.intBuffer);
        return this.bufs.intBuffer.get(0);
    }

    public void glGenFramebuffers(int n, int[] framebuffers, int offset) {
        this.bufs.resizeIntBuffer(n);
        this.glGenFramebuffers(n, this.bufs.intBuffer);
        this.bufs.intBuffer.get(framebuffers, offset, n);
    }

    public int glGenRenderbuffer() {
        this.bufs.resizeIntBuffer(1);
        this.glGenRenderbuffers(1, this.bufs.intBuffer);
        return this.bufs.intBuffer.get(0);
    }

    public void glGenRenderbuffers(int n, int[] renderbuffers, int offset) {
        this.bufs.resizeIntBuffer(n);
        this.glGenRenderbuffers(n, this.bufs.intBuffer);
        this.bufs.intBuffer.get(renderbuffers, offset, n);
    }

    public int glGenTexture() {
        this.bufs.resizeIntBuffer(1);
        this.glGenTextures(1, this.bufs.intBuffer);
        return this.bufs.intBuffer.get(0);
    }

    public void glGenTextures(int n, int[] textures, int offset) {
        this.bufs.resizeIntBuffer(n);
        this.glGenTextures(n, this.bufs.intBuffer);
        this.bufs.intBuffer.get(textures, offset, n);
    }

    public void glGetAttachedShaders(int program, int maxcount, int[] count, int countOffset, int[] shaders, int shadersOffset) {
        int countLength = count.length - countOffset;
        this.bufs.resizeIntBuffer(countLength);
        int shadersLength = shaders.length - shadersOffset;
        IntBuffer intBuffer2 = this.bufs.createIntBuffer(shadersLength);
        this.glGetAttachedShaders(program, maxcount, this.bufs.intBuffer, intBuffer2);
        this.bufs.intBuffer.get(count, countOffset, countLength);
        intBuffer2.get(shaders, shadersOffset, shadersLength);
    }

    public void glGetBooleanv(int pname, byte[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeByteBuffer(length);
        this.glGetBooleanv(pname, this.bufs.byteBuffer);
        this.bufs.byteBuffer.get(params, offset, length);
    }

    public void glGetBufferParameteriv(int target, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetBufferParameteriv(target, pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetFloatv(int pname, float[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeFloatBuffer(length);
        this.glGetFloatv(pname, this.bufs.floatBuffer);
        this.bufs.floatBuffer.get(params, offset, length);
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetFramebufferAttachmentParameteriv(target, attachment, pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetIntegerv(int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetIntegerv(pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetProgramBinary(int program, int bufsize, int[] length, int lengthOffset, int[] binaryformat, int binaryformatOffset, Buffer binary) {
        int lengthLength = bufsize - lengthOffset;
        this.bufs.resizeIntBuffer(lengthLength);
        int binaryformatLength = bufsize - binaryformatOffset;
        IntBuffer intBuffer2 = this.bufs.createIntBuffer(binaryformatLength);
        this.glGetProgramBinary(program, bufsize, this.bufs.intBuffer, intBuffer2, binary);
        this.bufs.intBuffer.get(length, lengthOffset, lengthLength);
        intBuffer2.get(binaryformat, binaryformatOffset, binaryformatLength);
    }

    public void glGetProgramInfoLog(int program, int bufsize, int[] length, int lengthOffset, byte[] infolog, int infologOffset) {
        int intLength = length.length - lengthOffset;
        this.bufs.resizeIntBuffer(intLength);
        int byteLength = bufsize - infologOffset;
        this.bufs.resizeByteBuffer(byteLength);
        this.glGetProgramInfoLog(program, bufsize, this.bufs.intBuffer, this.bufs.byteBuffer);
        this.bufs.intBuffer.get(length, lengthOffset, intLength);
        this.bufs.byteBuffer.get(infolog, byteLength, infologOffset);
    }

    public void glGetProgramiv(int program, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetProgramiv(program, pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetRenderbufferParameteriv(int target, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetRenderbufferParameteriv(target, pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetShaderInfoLog(int shader, int bufsize, int[] length, int lengthOffset, byte[] infolog, int infologOffset) {
        int intLength = length.length - lengthOffset;
        this.bufs.resizeIntBuffer(intLength);
        int byteLength = bufsize - infologOffset;
        this.bufs.resizeByteBuffer(byteLength);
        this.glGetShaderInfoLog(shader, bufsize, this.bufs.intBuffer, this.bufs.byteBuffer);
        this.bufs.intBuffer.get(length, lengthOffset, intLength);
        this.bufs.byteBuffer.get(infolog, byteLength, infologOffset);
    }

    public void glGetShaderiv(int shader, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetShaderiv(shader, pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetTexParameterfv(int target, int pname, float[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeFloatBuffer(length);
        this.glGetTexParameterfv(target, pname, this.bufs.floatBuffer);
        this.bufs.floatBuffer.get(params, offset, length);
    }

    public void glGetTexParameteriv(int target, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetTexParameteriv(target, pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetUniformfv(int program, int location, float[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeFloatBuffer(length);
        this.glGetUniformfv(program, location, this.bufs.floatBuffer);
        this.bufs.floatBuffer.get(params, offset, length);
    }

    public void glGetUniformiv(int program, int location, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetUniformiv(program, location, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glGetVertexAttribfv(int index, int pname, float[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeFloatBuffer(length);
        this.glGetVertexAttribfv(index, pname, this.bufs.floatBuffer);
        this.bufs.floatBuffer.get(params, offset, length);
    }

    public void glGetVertexAttribiv(int index, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.resizeIntBuffer(length);
        this.glGetVertexAttribiv(index, pname, this.bufs.intBuffer);
        this.bufs.intBuffer.get(params, offset, length);
    }

    public void glTexParameterfv(int target, int pname, float[] params, int offset) {
        int length = params.length - offset;
        this.bufs.setFloatBuffer(params, offset, length);
        this.glTexParameterfv(target, pname, this.bufs.floatBuffer);
    }

    public void glTexParameteriv(int target, int pname, int[] params, int offset) {
        int length = params.length - offset;
        this.bufs.setIntBuffer(params, offset, length);
        this.glTexParameteriv(target, pname, this.bufs.intBuffer);
    }

    public void glUniform1fv(int location, int count, float[] v, int offset) {
        this.bufs.setFloatBuffer(v, offset, count);
        this.glUniform1fv(location, count, this.bufs.floatBuffer);
    }

    public void glUniform1iv(int location, int count, int[] v, int offset) {
        this.bufs.setIntBuffer(v, offset, count);
        this.glUniform1iv(location, count, this.bufs.intBuffer);
    }

    public void glUniform2fv(int location, int count, float[] v, int offset) {
        this.bufs.setFloatBuffer(v, 2 * offset, 2 * count);
        this.glUniform2fv(location, count, this.bufs.floatBuffer);
    }

    public void glUniform2iv(int location, int count, int[] v, int offset) {
        this.bufs.setIntBuffer(v, 2 * offset, 2 * count);
        this.glUniform2iv(location, count, this.bufs.intBuffer);
    }

    public void glUniform3fv(int location, int count, float[] v, int offset) {
        this.bufs.setFloatBuffer(v, 3 * offset, 3 * count);
        this.glUniform3fv(location, count, this.bufs.floatBuffer);
    }

    public void glUniform3iv(int location, int count, int[] v, int offset) {
        this.bufs.setIntBuffer(v, 3 * offset, 3 * count);
        this.glUniform3iv(location, count, this.bufs.intBuffer);
    }

    public void glUniform4fv(int location, int count, float[] v, int offset) {
        this.bufs.setFloatBuffer(v, 4 * offset, 4 * count);
        this.glUniform4fv(location, count, this.bufs.floatBuffer);
    }

    public void glUniform4iv(int location, int count, int[] v, int offset) {
        this.bufs.setIntBuffer(v, 4 * offset, 4 * count);
        this.glUniform4iv(location, count, this.bufs.intBuffer);
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, float[] value, int offset) {
        this.bufs.setFloatBuffer(value, 4 * offset, 4 * count);
        this.glUniformMatrix2fv(location, count, transpose, this.bufs.floatBuffer);
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, float[] value, int offset) {
        this.bufs.setFloatBuffer(value, 4 * offset, 9 * count);
        this.glUniformMatrix3fv(location, count, transpose, this.bufs.floatBuffer);
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, float[] value, int offset) {
        this.bufs.setFloatBuffer(value, 16 * offset, 16 * count);
        this.glUniformMatrix4fv(location, count, transpose, this.bufs.floatBuffer);
    }

    public void glVertexAttrib1fv(int indx, float[] values, int offset) {
        this.glVertexAttrib1f(indx, values[indx + offset]);
    }

    public void glVertexAttrib2fv(int indx, float[] values, int offset) {
        this.glVertexAttrib2f(indx, values[indx + offset], values[indx + 1 + offset]);
    }

    public void glVertexAttrib3fv(int indx, float[] values, int offset) {
        this.glVertexAttrib3f(indx, values[indx + offset], values[indx + 1 + offset], values[indx + 2 + offset]);
    }

    public void glVertexAttrib4fv(int indx, float[] values, int offset) {
        this.glVertexAttrib4f(indx, values[indx + offset], values[indx + 1 + offset], values[indx + 2 + offset], values[indx + 3 + offset]);
    }

    public abstract String getPlatformGLExtensions();

    public abstract int getSwapInterval();

    public abstract void glActiveTexture(int var1);

    public abstract void glAttachShader(int var1, int var2);

    public abstract void glBindAttribLocation(int var1, int var2, String var3);

    public abstract void glBindBuffer(int var1, int var2);

    public abstract void glBindFramebuffer(int var1, int var2);

    public abstract void glBindRenderbuffer(int var1, int var2);

    public abstract void glBindTexture(int var1, int var2);

    public abstract void glBlendColor(float var1, float var2, float var3, float var4);

    public abstract void glBlendEquation(int var1);

    public abstract void glBlendEquationSeparate(int var1, int var2);

    public abstract void glBlendFunc(int var1, int var2);

    public abstract void glBlendFuncSeparate(int var1, int var2, int var3, int var4);

    public abstract void glBufferData(int var1, int var2, Buffer var3, int var4);

    public abstract void glBufferSubData(int var1, int var2, int var3, Buffer var4);

    public abstract int glCheckFramebufferStatus(int var1);

    public abstract void glClear(int var1);

    public abstract void glClearColor(float var1, float var2, float var3, float var4);

    public abstract void glClearDepth(double var1);

    public abstract void glClearDepthf(float var1);

    public abstract void glClearStencil(int var1);

    public abstract void glColorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract void glCompileShader(int var1);

    public abstract void glCompressedTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, Buffer var8);

    public abstract void glCompressedTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void glCompressedTexImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void glCompressedTexImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void glCompressedTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void glCompressedTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void glCompressedTexSubImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Buffer var11);

    public abstract void glCompressedTexSubImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public abstract void glCopyTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void glCopyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void glCopyTexSubImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract int glCreateProgram();

    public abstract int glCreateShader(int var1);

    public abstract void glCullFace(int var1);

    public abstract void glDeleteBuffers(int var1, IntBuffer var2);

    public abstract void glDeleteFramebuffers(int var1, IntBuffer var2);

    public abstract void glDeleteProgram(int var1);

    public abstract void glDeleteRenderbuffers(int var1, IntBuffer var2);

    public abstract void glDeleteShader(int var1);

    public abstract void glDeleteTextures(int var1, IntBuffer var2);

    public abstract void glDepthFunc(int var1);

    public abstract void glDepthMask(boolean var1);

    public abstract void glDepthRange(double var1, double var3);

    public abstract void glDepthRangef(float var1, float var2);

    public abstract void glDetachShader(int var1, int var2);

    public abstract void glDisable(int var1);

    public abstract void glDisableVertexAttribArray(int var1);

    public abstract void glDrawArrays(int var1, int var2, int var3);

    public abstract void glDrawElements(int var1, int var2, int var3, Buffer var4);

    public abstract void glDrawElements(int var1, int var2, int var3, int var4);

    public abstract void glEnable(int var1);

    public abstract void glEnableVertexAttribArray(int var1);

    public abstract void glFinish();

    public abstract void glFlush();

    public abstract void glFramebufferRenderbuffer(int var1, int var2, int var3, int var4);

    public abstract void glFramebufferTexture2D(int var1, int var2, int var3, int var4, int var5);

    public abstract void glFramebufferTexture3D(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void glFrontFace(int var1);

    public abstract void glGenBuffers(int var1, IntBuffer var2);

    public abstract void glGenerateMipmap(int var1);

    public abstract void glGenFramebuffers(int var1, IntBuffer var2);

    public abstract void glGenRenderbuffers(int var1, IntBuffer var2);

    public abstract void glGenTextures(int var1, IntBuffer var2);

    public abstract String glGetActiveAttrib(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract String glGetActiveUniform(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract void glGetAttachedShaders(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract int glGetAttribLocation(int var1, String var2);

    public abstract boolean glGetBoolean(int var1);

    public abstract void glGetBooleanv(int var1, ByteBuffer var2);

    public abstract int glGetBoundBuffer(int var1);

    public abstract void glGetBufferParameteriv(int var1, int var2, IntBuffer var3);

    public abstract int glGetError();

    public abstract float glGetFloat(int var1);

    public abstract void glGetFloatv(int var1, FloatBuffer var2);

    public abstract void glGetFramebufferAttachmentParameteriv(int var1, int var2, int var3, IntBuffer var4);

    public abstract int glGetInteger(int var1);

    public abstract void glGetIntegerv(int var1, IntBuffer var2);

    public abstract void glGetProgramBinary(int var1, int var2, IntBuffer var3, IntBuffer var4, Buffer var5);

    public abstract void glGetProgramInfoLog(int var1, int var2, IntBuffer var3, ByteBuffer var4);

    public abstract String glGetProgramInfoLog(int var1);

    public abstract void glGetProgramiv(int var1, int var2, IntBuffer var3);

    public abstract void glGetRenderbufferParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void glGetShaderInfoLog(int var1, int var2, IntBuffer var3, ByteBuffer var4);

    public abstract String glGetShaderInfoLog(int var1);

    public abstract void glGetShaderiv(int var1, int var2, IntBuffer var3);

    public abstract void glGetShaderPrecisionFormat(int var1, int var2, int[] var3, int var4, int[] var5, int var6);

    public abstract void glGetShaderPrecisionFormat(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public abstract void glGetShaderSource(int var1, int var2, int[] var3, int var4, byte[] var5, int var6);

    public abstract void glGetShaderSource(int var1, int var2, IntBuffer var3, ByteBuffer var4);

    public abstract String glGetString(int var1);

    public abstract void glGetTexParameterfv(int var1, int var2, FloatBuffer var3);

    public abstract void glGetTexParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void glGetUniformfv(int var1, int var2, FloatBuffer var3);

    public abstract void glGetUniformiv(int var1, int var2, IntBuffer var3);

    public abstract int glGetUniformLocation(int var1, String var2);

    public abstract void glGetVertexAttribfv(int var1, int var2, FloatBuffer var3);

    public abstract void glGetVertexAttribiv(int var1, int var2, IntBuffer var3);

    public abstract void glHint(int var1, int var2);

    public abstract boolean glIsBuffer(int var1);

    public abstract boolean glIsEnabled(int var1);

    public abstract boolean glIsFramebuffer(int var1);

    public abstract boolean glIsProgram(int var1);

    public abstract boolean glIsRenderbuffer(int var1);

    public abstract boolean glIsShader(int var1);

    public abstract boolean glIsTexture(int var1);

    public abstract boolean glIsVBOArrayEnabled();

    public abstract boolean glIsVBOElementEnabled();

    public abstract void glLineWidth(float var1);

    public abstract void glLinkProgram(int var1);

    public abstract ByteBuffer glMapBuffer(int var1, int var2);

    public abstract void glPixelStorei(int var1, int var2);

    public abstract void glPolygonOffset(float var1, float var2);

    public abstract void glProgramBinary(int var1, int var2, Buffer var3, int var4);

    public abstract void glReadPixels(int var1, int var2, int var3, int var4, int var5, int var6, Buffer var7);

    public abstract void glReadPixels(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void glReleaseShaderCompiler();

    public abstract void glRenderbufferStorage(int var1, int var2, int var3, int var4);

    public abstract void glSampleCoverage(float var1, boolean var2);

    public abstract void glScissor(int var1, int var2, int var3, int var4);

    public abstract void glShaderBinary(int var1, int[] var2, int var3, int var4, Buffer var5, int var6);

    public abstract void glShaderBinary(int var1, IntBuffer var2, int var3, Buffer var4, int var5);

    public abstract void glShaderSource(int var1, int var2, String[] var3, int[] var4, int var5);

    public abstract void glShaderSource(int var1, int var2, String[] var3, IntBuffer var4);

    public abstract void glShaderSource(int var1, String var2);

    public abstract void glStencilFunc(int var1, int var2, int var3);

    public abstract void glStencilFuncSeparate(int var1, int var2, int var3, int var4);

    public abstract void glStencilMask(int var1);

    public abstract void glStencilMaskSeparate(int var1, int var2);

    public abstract void glStencilOp(int var1, int var2, int var3);

    public abstract void glStencilOpSeparate(int var1, int var2, int var3, int var4);

    public abstract void glTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void glTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void glTexImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Buffer var10);

    public abstract void glTexImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract void glTexParameterf(int var1, int var2, float var3);

    public abstract void glTexParameterfv(int var1, int var2, FloatBuffer var3);

    public abstract void glTexParameteri(int var1, int var2, int var3);

    public abstract void glTexParameteriv(int var1, int var2, IntBuffer var3);

    public abstract void glTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public abstract void glTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void glTexSubImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Buffer var11);

    public abstract void glTexSubImage3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public abstract void glUniform1f(int var1, float var2);

    public abstract void glUniform1fv(int var1, int var2, FloatBuffer var3);

    public abstract void glUniform1i(int var1, int var2);

    public abstract void glUniform1iv(int var1, int var2, IntBuffer var3);

    public abstract void glUniform2f(int var1, float var2, float var3);

    public abstract void glUniform2fv(int var1, int var2, FloatBuffer var3);

    public abstract void glUniform2i(int var1, int var2, int var3);

    public abstract void glUniform2iv(int var1, int var2, IntBuffer var3);

    public abstract void glUniform3f(int var1, float var2, float var3, float var4);

    public abstract void glUniform3fv(int var1, int var2, FloatBuffer var3);

    public abstract void glUniform3i(int var1, int var2, int var3, int var4);

    public abstract void glUniform3iv(int var1, int var2, IntBuffer var3);

    public abstract void glUniform4f(int var1, float var2, float var3, float var4, float var5);

    public abstract void glUniform4fv(int var1, int var2, FloatBuffer var3);

    public abstract void glUniform4i(int var1, int var2, int var3, int var4, int var5);

    public abstract void glUniform4iv(int var1, int var2, IntBuffer var3);

    public abstract void glUniformMatrix2fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void glUniformMatrix3fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract void glUniformMatrix4fv(int var1, int var2, boolean var3, FloatBuffer var4);

    public abstract boolean glUnmapBuffer(int var1);

    public abstract void glUseProgram(int var1);

    public abstract void glValidateProgram(int var1);

    public abstract void glVertexAttrib1f(int var1, float var2);

    public abstract void glVertexAttrib1fv(int var1, FloatBuffer var2);

    public abstract void glVertexAttrib2f(int var1, float var2, float var3);

    public abstract void glVertexAttrib2fv(int var1, FloatBuffer var2);

    public abstract void glVertexAttrib3f(int var1, float var2, float var3, float var4);

    public abstract void glVertexAttrib3fv(int var1, FloatBuffer var2);

    public abstract void glVertexAttrib4f(int var1, float var2, float var3, float var4, float var5);

    public abstract void glVertexAttrib4fv(int var1, FloatBuffer var2);

    public abstract void glVertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, Buffer var6);

    public abstract void glVertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, int var6);

    public abstract void glViewport(int var1, int var2, int var3, int var4);

    public abstract boolean hasGLSL();

    public abstract boolean isExtensionAvailable(String var1);

    public abstract boolean isFunctionAvailable(String var1);

    public static abstract class Buffers {
        public IntBuffer intBuffer = this.createIntBuffer(32);
        public FloatBuffer floatBuffer = this.createFloatBuffer(32);
        public ShortBuffer shortBuffer = this.createShortBuffer(32);
        public ByteBuffer byteBuffer = this.createByteBuffer(256);

        public void setByteBuffer(byte[] source, int offset, int length) {
            this.resizeByteBuffer(length - offset);
            this.byteBuffer.put(source, offset, length);
            this.byteBuffer.rewind();
        }

        public void setShortBuffer(short[] source, int offset, int length) {
            this.resizeShortBuffer(length - offset);
            this.shortBuffer.put(source, offset, length);
            this.shortBuffer.rewind();
        }

        public void setIntBuffer(int[] source, int offset, int length) {
            this.resizeIntBuffer(length - offset);
            this.intBuffer.put(source, offset, length);
            this.intBuffer.rewind();
        }

        public void setFloatBuffer(float[] source, int offset, int length) {
            this.resizeFloatBuffer(length - offset);
            this.floatBuffer.put(source, offset, length);
            this.floatBuffer.rewind();
        }

        public void setShortBuffer(short n) {
            this.shortBuffer.position(0);
            this.shortBuffer.put(n);
            this.shortBuffer.rewind();
        }

        public void setIntBuffer(int n) {
            this.intBuffer.position(0);
            this.intBuffer.put(n);
            this.intBuffer.rewind();
        }

        public void setFloatBuffer(float n) {
            this.floatBuffer.position(0);
            this.floatBuffer.put(n);
            this.floatBuffer.rewind();
        }

        public void resizeByteBuffer(int length) {
            int cap = this.byteBuffer.capacity();
            if (cap < length) {
                this.byteBuffer = this.createByteBuffer(this.newCap(cap, length));
            } else {
                this.byteBuffer.position(0);
            }
            this.byteBuffer.limit(length);
        }

        public void resizeShortBuffer(int length) {
            int cap = this.shortBuffer.capacity();
            if (cap < length) {
                this.shortBuffer = this.createShortBuffer(this.newCap(cap, length));
            } else {
                this.shortBuffer.position(0);
            }
            this.shortBuffer.limit(length);
        }

        public void resizeIntBuffer(int length) {
            int cap = this.intBuffer.capacity();
            if (cap < length) {
                this.intBuffer = this.createIntBuffer(this.newCap(cap, length));
            } else {
                this.intBuffer.position(0);
            }
            this.intBuffer.limit(length);
        }

        public void resizeFloatBuffer(int length) {
            int cap = this.floatBuffer.capacity();
            if (cap < length) {
                this.floatBuffer = this.createFloatBuffer(this.newCap(cap, length));
            } else {
                this.floatBuffer.position(0);
            }
            this.floatBuffer.limit(length);
        }

        public abstract ByteBuffer createByteBuffer(int var1);

        public ShortBuffer createShortBuffer(int size) {
            return this.createByteBuffer(size * 2).asShortBuffer();
        }

        public IntBuffer createIntBuffer(int size) {
            return this.createByteBuffer(size * 4).asIntBuffer();
        }

        public FloatBuffer createFloatBuffer(int size) {
            return this.createByteBuffer(size * 4).asFloatBuffer();
        }

        private int newCap(int cap, int length) {
            int newLength;
            for (newLength = cap << 1; newLength < length; newLength <<= 1) {
            }
            return newLength;
        }
    }
}

