/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.util.ArrayList;
import java.util.List;
import playn.core.Platform;
import react.RPromise;
import react.SignalView;
import react.Slot;

public abstract class Exec {
    public abstract boolean isMainThread();

    public abstract void invokeLater(Runnable var1);

    public <T> RPromise<T> deferredPromise() {
        return new RPromise<T>(){

            public void succeed(final T value) {
                Exec.this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.superSucceed(value);
                    }
                });
            }

            public void fail(final Throwable cause) {
                Exec.this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.superFail(cause);
                    }
                });
            }

            private void superSucceed(T value) {
                super.succeed(value);
            }

            private void superFail(Throwable cause) {
                super.fail(cause);
            }
        };
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public void invokeAsync(Runnable action) {
        throw new UnsupportedOperationException();
    }

    public static abstract class Default
    extends Exec {
        private final List<Runnable> pending = new ArrayList<Runnable>();
        private final List<Runnable> running = new ArrayList<Runnable>();
        protected final Platform plat;

        public Default(Platform plat) {
            this.plat = plat;
            plat.frame.connect((SignalView.Listener)new Slot<Object>(){

                public void onEmit(Object unused) {
                    Default.this.dispatch();
                }
            }).atPrio(Short.MAX_VALUE);
        }

        @Override
        public synchronized void invokeLater(Runnable action) {
            this.pending.add(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch() {
            Default default_ = this;
            synchronized (default_) {
                this.running.addAll(this.pending);
                this.pending.clear();
            }
            int ll = this.running.size();
            for (int ii = 0; ii < ll; ++ii) {
                Runnable action = this.running.get(ii);
                try {
                    action.run();
                    continue;
                }
                catch (Throwable e) {
                    this.plat.reportError("invokeLater Runnable failed: " + action, e);
                }
            }
            this.running.clear();
        }
    }
}

