/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.streams.impl;

import io.pkts.packet.Packet;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.SipPacketParseException;
import io.pkts.packet.sip.SipRequestPacket;
import io.pkts.packet.sip.SipResponsePacket;
import io.pkts.streams.SipStream;
import io.pkts.streams.impl.PacketComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleCallStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCallStateMachine.class);
    private NavigableSet<SipPacket> messages;
    private List<SipStream.CallState> callTransitions;
    private SipStream.CallState currentState;
    private final String callId;
    private SipResponsePacket ringingResponse;
    private SipResponsePacket successResponse;
    private SipRequestPacket byeRequest;
    private boolean handshakeIsComplete;
    private boolean reTransmisionsDetected = false;

    public SimpleCallStateMachine(String callId) {
        this.callId = callId;
        this.init();
    }

    private void init() {
        this.currentState = SipStream.CallState.START;
        this.callTransitions = new ArrayList<SipStream.CallState>();
        this.messages = new TreeSet<Packet>(new PacketComparator());
    }

    public long getTimeOfFirstMessage() {
        if (this.messages.isEmpty()) {
            return -1L;
        }
        return ((SipPacket)this.messages.first()).getArrivalTime();
    }

    public long getTimeOfLastMessage() {
        if (this.messages.isEmpty()) {
            return -1L;
        }
        return ((SipPacket)this.messages.last()).getArrivalTime();
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeIsComplete;
    }

    public boolean reTransmitsDetected() {
        return this.reTransmisionsDetected;
    }

    public void onEvent(SipPacket msg) throws SipPacketParseException {
        if (msg == null) {
            return;
        }
        SipPacket previousMsg = this.messages.isEmpty() ? null : (SipPacket)this.messages.last();
        this.messages.add(msg);
        if (previousMsg != null && msg.getArrivalTime() < previousMsg.getArrivalTime()) {
            this.redrive();
            return;
        }
        try {
            this.handleStateChange(msg);
        }
        catch (SipPacketParseException e) {
            e.printStackTrace();
        }
    }

    private void handleStateChange(SipPacket msg) throws SipPacketParseException {
        switch (this.currentState) {
            case START: {
                this.initializeState(msg);
                break;
            }
            case INITIAL: 
            case TRYING: 
            case RINGING: {
                this.handleInProvisionalState(msg);
                break;
            }
            case IN_CALL: {
                this.handleInConfirmedState(msg);
                break;
            }
            case COMPLETED: {
                this.handleInCompletedState(msg);
                break;
            }
            case REDIRECT: 
            case REJECTED: 
            case FAILED: {
                this.handleInErrorState(msg);
                break;
            }
            case CANCELLING: {
                this.handleInCancellingState(msg);
                break;
            }
            case CANCELLED: {
                this.handleInCancelledState(msg);
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown state, should be impossible. State is: " + (Object)((Object)this.currentState));
            }
        }
    }

    private void handleInCancelledState(SipPacket msg) throws SipPacketParseException {
        if (msg.isRequest() && msg.isAck()) {
            this.handshakeIsComplete = true;
        }
        this.transition(this.currentState, msg);
    }

    private void handleInCancellingState(SipPacket msg) throws SipPacketParseException {
        SipResponsePacket response;
        if (msg.isCancel()) {
            this.transition(SipStream.CallState.CANCELLING, msg);
            return;
        }
        if (!msg.isRequest() && (response = msg.toResponse()).isInvite()) {
            if (response.getStatus() == 487) {
                this.transition(SipStream.CallState.CANCELLED, msg);
            } else if (response.isSuccess()) {
                this.transition(SipStream.CallState.IN_CALL, msg);
            }
        }
    }

    private void handleInErrorState(SipPacket msg) throws SipPacketParseException {
        if (msg.isRequest() && msg.isAck()) {
            this.handshakeIsComplete = true;
        }
        this.transition(this.currentState, msg);
    }

    private void handleInCompletedState(SipPacket msg) throws SipPacketParseException {
        if (!msg.isRequest() && msg.isBye()) {
            this.transition(SipStream.CallState.COMPLETED, msg);
        }
    }

    private void handleInConfirmedState(SipPacket msg) throws SipPacketParseException {
        if (msg.isRequest()) {
            if (msg.isBye()) {
                if (this.byeRequest == null) {
                    this.byeRequest = msg.toRequest();
                }
                this.transition(SipStream.CallState.COMPLETED, msg);
            } else if (msg.isAck()) {
                this.handshakeIsComplete = true;
                this.transition(SipStream.CallState.IN_CALL, msg);
            }
        } else {
            SipResponsePacket response = (SipResponsePacket)msg;
            if (response.isSuccess()) {
                this.reTransmisionsDetected = true;
            } else if (response.isBye()) {
                // empty if block
            }
        }
    }

    private void handleInProvisionalState(SipPacket msg) throws SipPacketParseException {
        if (msg.isRequest() && msg.isCancel()) {
            this.transition(SipStream.CallState.CANCELLING, msg);
            return;
        }
        if (msg.isRequest()) {
            this.transition(this.currentState, msg);
            return;
        }
        boolean isInvite = msg.isInvite();
        SipResponsePacket response = (SipResponsePacket)msg;
        if (response.is100Trying()) {
            this.transition(SipStream.CallState.TRYING, msg);
        } else if (response.isRinging()) {
            if (this.ringingResponse == null) {
                this.ringingResponse = msg.toResponse();
            }
            this.transition(SipStream.CallState.RINGING, msg);
        } else if (response.isSuccess() && isInvite) {
            if (this.successResponse == null) {
                this.successResponse = msg.toResponse();
            }
            this.transition(SipStream.CallState.IN_CALL, msg);
        } else if (response.isRedirect()) {
            this.transition(SipStream.CallState.REDIRECT, msg);
        } else if (this.isRejected(response.getStatus())) {
            this.transition(SipStream.CallState.REJECTED, msg);
        } else if (response.isClientError()) {
            this.transition(SipStream.CallState.FAILED, msg);
        } else if (response.isServerError()) {
            this.transition(SipStream.CallState.FAILED, msg);
        } else if (response.isGlobalError()) {
            this.transition(SipStream.CallState.FAILED, msg);
        }
    }

    private boolean isRejected(int status) {
        return status == 401 || status == 403 || status == 404 || status == 407 || status == 480 || status == 486 || status == 603;
    }

    private void initializeState(SipPacket msg) throws SipPacketParseException {
        if (msg.isRequest()) {
            if (msg.isInvite() && msg.isInitial()) {
                this.transition(SipStream.CallState.INITIAL, msg);
            } else if (msg.isAck()) {
                this.transition(SipStream.CallState.IN_CALL, msg);
            } else if (msg.isBye() && !msg.isInitial()) {
                this.transition(SipStream.CallState.COMPLETED, msg);
            }
        } else {
            SipResponsePacket response = (SipResponsePacket)msg;
            if (response.isInvite()) {
                if (response.is100Trying()) {
                    this.transition(SipStream.CallState.TRYING, msg);
                } else if (response.isRinging()) {
                    this.transition(SipStream.CallState.RINGING, msg);
                } else if (response.isSuccess()) {
                    this.transition(SipStream.CallState.IN_CALL, msg);
                }
            } else if (response.isBye() && !response.isInitial()) {
                this.transition(SipStream.CallState.COMPLETED, msg);
            }
        }
    }

    private void transition(SipStream.CallState nextState, SipPacket msg) {
        SipStream.CallState previousState = this.currentState;
        this.currentState = nextState;
        if (previousState != nextState) {
            this.callTransitions.add(nextState);
        }
        if (logger.isInfoEnabled()) {
            logger.info("[{}] {} -> {} Event: {}", new Object[]{this.callId, previousState, this.currentState, msg.getInitialLine()});
        }
    }

    private void redrive() throws SipPacketParseException {
        if (logger.isInfoEnabled()) {
            logger.info("Out-of-sequence event detected. Redriving all traffic.");
        }
        NavigableSet<SipPacket> oldMessages = this.messages;
        this.init();
        while (!oldMessages.isEmpty()) {
            SipPacket msg = oldMessages.pollFirst();
            this.onEvent(msg);
        }
    }

    public boolean isTerminated() {
        return this.currentState == SipStream.CallState.COMPLETED || this.currentState == SipStream.CallState.REJECTED || this.currentState == SipStream.CallState.CANCELLED || this.currentState == SipStream.CallState.FAILED || this.currentState == SipStream.CallState.REDIRECT;
    }

    public List<SipPacket> getMessages() {
        return new ArrayList<SipPacket>(this.messages);
    }

    public List<SipStream.CallState> getTransitions() {
        return Collections.unmodifiableList(this.callTransitions);
    }

    public SipStream.CallState getCallState() {
        return this.currentState;
    }

    public long getPostDialDelay() throws SipPacketParseException {
        long t2;
        if (this.messages.isEmpty() || this.ringingResponse == null && this.successResponse == null) {
            return -1L;
        }
        long t1 = ((SipPacket)this.messages.first()).getArrivalTime();
        long l = t2 = this.ringingResponse != null ? this.ringingResponse.getArrivalTime() : this.successResponse.getArrivalTime();
        if (t1 == t2) {
            return -1L;
        }
        return t2 - t1;
    }

    public long getDuration() {
        long t2;
        if (this.messages.isEmpty() || this.byeRequest == null) {
            return -1L;
        }
        long t1 = ((SipPacket)this.messages.first()).getArrivalTime();
        if (t1 == (t2 = this.byeRequest.getArrivalTime())) {
            return -1L;
        }
        return t2 - t1;
    }
}

