/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.streams.impl;

import io.pkts.PcapOutputStream;
import io.pkts.frame.PcapGlobalHeader;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.SipPacketParseException;
import io.pkts.sdp.SDP;
import io.pkts.streams.SipStream;
import io.pkts.streams.StreamId;
import io.pkts.streams.impl.SimpleCallStateMachine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class BasicSipStream
implements SipStream {
    private final StreamId streamIdentifier;
    private final SimpleCallStateMachine fsm;
    private final PcapGlobalHeader globalHeader;

    public BasicSipStream(PcapGlobalHeader globalHeader, StreamId streamIdentifier) {
        this.globalHeader = globalHeader;
        this.streamIdentifier = streamIdentifier;
        this.fsm = new SimpleCallStateMachine(this.streamIdentifier.asString());
    }

    @Override
    public void addMessage(SipPacket message) throws SipPacketParseException {
        this.fsm.onEvent(message);
    }

    @Override
    public boolean isTerminated() {
        return this.fsm.isTerminated();
    }

    @Override
    public List<SipPacket> getPackets() {
        return this.fsm.getMessages();
    }

    @Override
    public long getPostDialDelay() throws SipPacketParseException {
        return this.fsm.getPostDialDelay();
    }

    @Override
    public long getDuration() {
        return this.fsm.getDuration();
    }

    @Override
    public StreamId getStreamIdentifier() {
        return this.streamIdentifier;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        for (SipPacket msg : this.fsm.getMessages()) {
            msg.write(out);
        }
    }

    @Override
    public SipStream.CallState getCallState() {
        return this.fsm.getCallState();
    }

    @Override
    public boolean handshakeComplete() {
        return this.fsm.isHandshakeCompleted();
    }

    @Override
    public boolean reTranmitsDetected() {
        return this.fsm.reTransmitsDetected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String filename) throws IOException {
        File file = new File(filename);
        FileOutputStream os = new FileOutputStream(file);
        try (PcapOutputStream out = PcapOutputStream.create((PcapGlobalHeader)this.globalHeader, (OutputStream)os);){
            this.write((OutputStream)out);
        }
    }

    @Override
    public void save(OutputStream out) throws IOException {
        this.globalHeader.write(out);
        this.write(out);
    }

    @Override
    public long getTimeOfFirstPacket() {
        return this.fsm.getTimeOfFirstMessage();
    }

    @Override
    public long getTimeOfLastPacket() {
        return this.fsm.getTimeOfLastMessage();
    }

    @Override
    public SipStream createEmptyClone() {
        return new BasicSipStream(this.globalHeader, this.streamIdentifier);
    }

    @Override
    public SDP getInviteSDP() throws SipPacketParseException {
        for (SipPacket msg : this.fsm.getMessages()) {
            if (!msg.isRequest() || !msg.isInvite()) continue;
            return this.getSDPorNull(msg);
        }
        return null;
    }

    @Override
    public SDP get200OkSDP() throws SipPacketParseException {
        for (SipPacket msg : this.fsm.getMessages()) {
            if (!msg.isResponse() || !msg.isInvite() || !msg.toResponse().isSuccess()) continue;
            return this.getSDPorNull(msg);
        }
        return null;
    }

    private SDP getSDPorNull(SipPacket msg) throws SipPacketParseException {
        Object content = msg.getContent();
        if (content instanceof SDP) {
            return (SDP)content;
        }
        return null;
    }
}

