/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.streams.impl;

import io.pkts.frame.PcapGlobalHeader;
import io.pkts.framer.FramerManager;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.protocol.Protocol;
import io.pkts.streams.RtpStream;
import io.pkts.streams.StreamListener;
import io.pkts.streams.impl.DefaultRtpStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtpStreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(RtpStreamHandler.class);
    private StreamListener<RtpPacket> rtpListener;
    private final Map<Long, DefaultRtpStream> streams = new HashMap<Long, DefaultRtpStream>();
    private final FramerManager framerManager;

    public RtpStreamHandler(FramerManager framerManager) {
        this.framerManager = framerManager;
    }

    public void processFrame(Packet frame) throws PacketParseException {
        try {
            RtpPacket rtp = (RtpPacket)frame.getPacket(Protocol.RTP);
            long ssrc = rtp.getSyncronizationSource();
            DefaultRtpStream stream = this.streams.get(ssrc);
            if (stream == null) {
                PcapGlobalHeader header = null;
                if (frame.hasProtocol(Protocol.SLL)) {
                    header = PcapGlobalHeader.createDefaultHeader((Protocol)Protocol.SLL);
                } else if (frame.hasProtocol(Protocol.ETHERNET_II)) {
                    header = PcapGlobalHeader.createDefaultHeader((Protocol)Protocol.ETHERNET_II);
                } else {
                    throw new PacketParseException(0, "Unable to create the PcapGlobalHeader because the link type isn't recognized. Currently only Ethernet II and Linux SLL (linux cooked capture) are implemented");
                }
                stream = new DefaultRtpStream(header, ssrc);
                this.streams.put(ssrc, stream);
                this.notifyStartStream(stream, rtp);
            } else {
                this.notifyPacketReceived(stream, rtp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addListener(StreamListener<RtpPacket> listener) {
        this.rtpListener = listener;
    }

    private void notifyStartStream(RtpStream stream, RtpPacket pkt) {
        if (this.rtpListener != null) {
            this.rtpListener.startStream(stream, pkt);
        }
    }

    private void notifyPacketReceived(RtpStream stream, RtpPacket pkt) {
        if (this.rtpListener != null) {
            this.rtpListener.packetReceived(stream, pkt);
        }
    }

    private void notifyEndStream(RtpStream stream) {
        if (this.rtpListener != null) {
            this.rtpListener.endStream(stream);
        }
    }
}

