/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.streams.impl;

import io.pkts.frame.PcapGlobalHeader;
import io.pkts.framer.FramerManager;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequestPacket;
import io.pkts.packet.sip.SipResponsePacket;
import io.pkts.protocol.Protocol;
import io.pkts.sdp.RTPInfo;
import io.pkts.sdp.SDP;
import io.pkts.streams.SipStatistics;
import io.pkts.streams.SipStream;
import io.pkts.streams.Stream;
import io.pkts.streams.StreamId;
import io.pkts.streams.StreamListener;
import io.pkts.streams.impl.BasicSipStream;
import io.pkts.streams.impl.BufferStreamId;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipStreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(SipStreamHandler.class);
    private final Map<StreamId, BasicSipStream> sipStreams = new HashMap<StreamId, BasicSipStream>();
    private final Map<StreamId, BasicSipStream> terminatedStreams = new HashMap<StreamId, BasicSipStream>();
    private StreamListener<SipPacket> sipListener;
    private final FramerManager framerManager;
    private final SipStatisticsImpl stats = new SipStatisticsImpl();

    public SipStreamHandler(FramerManager framerManager) {
        this.framerManager = framerManager;
    }

    private StreamId getStreamId(SipPacket msg) throws SipParseException {
        try {
            return new BufferStreamId(msg.getCallIDHeader().getValue());
        }
        catch (NullPointerException e) {
            System.err.println("============= holy shit, we blew up =================");
            System.err.println(msg);
            System.err.println("============= holy shit, we blew up =================");
            throw e;
        }
    }

    public void processFrame(Packet frame) throws PacketParseException {
        try {
            SipPacket msg = (SipPacket)frame.getPacket(Protocol.SIP);
            StreamId id = this.getStreamId(msg);
            if (id == null) {
                return;
            }
            this.stats.count(msg);
            if (msg.isInfo() || msg.isOptions() || msg.isMessage()) {
                return;
            }
            BasicSipStream stream = this.sipStreams.get(id);
            if (stream == null) {
                stream = this.terminatedStreams.get(id);
            }
            if (stream == null) {
                PcapGlobalHeader header = null;
                if (frame.hasProtocol(Protocol.SLL)) {
                    header = PcapGlobalHeader.createDefaultHeader((Protocol)Protocol.SLL);
                } else if (frame.hasProtocol(Protocol.ETHERNET_II)) {
                    header = PcapGlobalHeader.createDefaultHeader((Protocol)Protocol.ETHERNET_II);
                } else {
                    throw new PacketParseException(0, "Unable to create the PcapGlobalHeader because the link type isn't recognized. Currently only Ethernet II and Linux SLL (linux cooked capture) are implemented");
                }
                stream = new BasicSipStream(header, id);
                stream.addMessage(msg);
                this.notifyStartStream(stream, msg);
                this.sipStreams.put(id, stream);
            } else {
                boolean wasAlreadyTerminated = stream.isTerminated();
                stream.addMessage(msg);
                this.notifyPacketReceived(stream, msg);
                if (!wasAlreadyTerminated && stream.isTerminated()) {
                    this.sipStreams.remove(id);
                    this.terminatedStreams.put(id, stream);
                    this.notifyEndStream(stream);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyStartStream(SipStream stream, SipPacket pkt) {
        if (this.sipListener != null) {
            this.sipListener.startStream(stream, pkt);
        }
    }

    private void notifyPacketReceived(SipStream stream, SipPacket pkt) {
        if (this.sipListener != null) {
            this.sipListener.packetReceived(stream, pkt);
        }
    }

    private void notifyEndStream(SipStream stream) {
        if (this.sipListener != null) {
            this.sipListener.endStream(stream);
        }
    }

    private void checkMessageForContent(SipPacket msg) {
        if (!msg.hasContent()) {
            return;
        }
        try {
            Object content = msg.getContent();
            if (content instanceof SDP) {
                for (RTPInfo rtpInfo : ((SDP)content).getRTPInfo()) {
                    String address = rtpInfo.getAddress();
                    int n = rtpInfo.getMediaPort();
                }
            }
        }
        catch (SipParseException e) {
            logger.warn("Unable to parse the content of the sip message", (Throwable)e);
        }
    }

    public void addListener(StreamListener<SipPacket> listener) {
        this.sipListener = listener;
    }

    public SipStatistics getStatistics() {
        return this.stats;
    }

    public Map<StreamId, ? extends Stream> getStreams() {
        return this.sipStreams;
    }

    private static class SipStatisticsImpl
    implements SipStatistics {
        private long total;
        private long inviteRequests;
        private long byeRequests;
        private long ackRequests;
        private long optionsRequests;
        private long messageRequests;
        private long infoRequests;
        private long cancelRequests;
        private final int[] responses = new int[600];

        public void count(SipPacket msg) throws SipParseException {
            ++this.total;
            if (msg.isRequest()) {
                this.countRequest(msg.toRequest());
            } else {
                this.countResponse(msg.toResponse());
            }
        }

        private void countRequest(SipRequestPacket request) throws SipParseException {
            if (request.isInvite()) {
                ++this.inviteRequests;
            } else if (request.isAck()) {
                ++this.ackRequests;
            } else if (request.isBye()) {
                ++this.byeRequests;
            } else if (request.isOptions()) {
                ++this.optionsRequests;
            } else if (request.isCancel()) {
                ++this.cancelRequests;
            } else if (request.isMessage()) {
                ++this.messageRequests;
            } else if (request.isInfo()) {
                ++this.infoRequests;
            }
        }

        private void countResponse(SipResponsePacket response) throws SipParseException {
            int n = response.getStatus() - 100;
            this.responses[n] = this.responses[n] + 1;
        }

        @Override
        public long totalSipMessages() {
            return this.total;
        }

        @Override
        public long totalInviteRequests() {
            return this.inviteRequests;
        }

        @Override
        public long totalAckRequests() {
            return this.ackRequests;
        }

        @Override
        public long totalByeRequests() {
            return this.byeRequests;
        }

        @Override
        public long totalOptionsRequests() {
            return this.optionsRequests;
        }

        @Override
        public long totalInfoRequests() {
            return this.infoRequests;
        }

        @Override
        public long totalCancelRequests() {
            return this.cancelRequests;
        }

        @Override
        public int[] totalResponses() {
            return this.responses;
        }

        public void dump() {
            int[] responses = this.totalResponses();
            for (int i = 0; i < responses.length; ++i) {
                if (responses[i] <= 0) continue;
                System.out.println(i + 100 + ": " + responses[i]);
            }
        }

        @Override
        public String dumpInfo() {
            StringBuilder sb = new StringBuilder();
            sb.append("Total: ").append(this.total);
            sb.append("\nRequests");
            sb.append("\n   INVITE: ").append(this.inviteRequests);
            sb.append("\n   ACK: ").append(this.ackRequests);
            sb.append("\n   OPTIONS: ").append(this.optionsRequests);
            sb.append("\n   BYE: ").append(this.byeRequests);
            sb.append("\n   MESSAGE: ").append(this.messageRequests);
            sb.append("\n   CANCEL: ").append(this.cancelRequests);
            sb.append("\n   INFO: ").append(this.infoRequests);
            sb.append("\nResponses: ");
            for (int i = 0; i < this.responses.length; ++i) {
                if (this.responses[i] <= 0) continue;
                sb.append("\n   ").append(i + 100).append(": ").append(this.responses[i]);
            }
            return sb.toString();
        }
    }
}

