/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.streams.impl;

import io.pkts.framer.FramerManager;
import io.pkts.packet.IPPacket;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.packet.sip.SipPacket;
import io.pkts.protocol.Protocol;
import io.pkts.streams.FragmentListener;
import io.pkts.streams.SipStatistics;
import io.pkts.streams.Stream;
import io.pkts.streams.StreamHandler;
import io.pkts.streams.StreamId;
import io.pkts.streams.StreamListener;
import io.pkts.streams.impl.RtpStreamHandler;
import io.pkts.streams.impl.SipStreamHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultStreamHandler
implements StreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStreamHandler.class);
    private final FramerManager framerManager = FramerManager.getInstance();
    private SipStreamHandler sipStreamHandler;
    private RtpStreamHandler rtpStreamHandler;
    private FragmentListener fragmentListener;

    public void nextPacket(Packet packet) {
        try {
            IPPacket ip;
            if (packet.hasProtocol(Protocol.IPv4) && (ip = (IPPacket)packet.getPacket(Protocol.IPv4)).isFragmented() && (packet = this.handleFragmentation(ip)) == null) {
                return;
            }
            if (this.sipStreamHandler != null && packet.hasProtocol(Protocol.SIP)) {
                this.sipStreamHandler.processFrame(packet);
            } else if (this.rtpStreamHandler != null && packet.hasProtocol(Protocol.RTP)) {
                this.rtpStreamHandler.processFrame(packet);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PacketParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addStreamListener(StreamListener<? extends Packet> listener) {
        try {
            Method method = listener.getClass().getMethod("endStream", Stream.class);
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericParameterTypes()[0];
            Type[] parameterArgTypes = parameterizedType.getActualTypeArguments();
            Type parameterArgType = parameterArgTypes[0];
            Class parameterArgClass = (Class)parameterArgType;
            if (parameterArgClass.equals(SipPacket.class)) {
                if (this.sipStreamHandler == null) {
                    this.sipStreamHandler = new SipStreamHandler(this.framerManager);
                }
                this.sipStreamHandler.addListener(listener);
            } else if (parameterArgClass.equals(RtpPacket.class)) {
                if (this.rtpStreamHandler == null) {
                    this.rtpStreamHandler = new RtpStreamHandler(this.framerManager);
                }
                this.rtpStreamHandler.addListener(listener);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Unable to figure out the paramterized type", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Unable to access method information due to security constraints", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The startStream method doesn't exist. Signature changed?", e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The supplied listener has not been parameterized");
        }
    }

    private IPPacket handleFragmentation(IPPacket ipPacket) {
        if (this.fragmentListener == null) {
            return null;
        }
        try {
            return this.fragmentListener.handleFragment(ipPacket);
        }
        catch (Throwable t) {
            logger.warn("Exception thrown by FragmentListener when processing the IP frame", t);
            return null;
        }
    }

    @Override
    public void setFragmentListener(FragmentListener listener) {
        this.fragmentListener = listener;
    }

    @Override
    public SipStatistics getSipStatistics() {
        if (this.sipStreamHandler != null) {
            return this.sipStreamHandler.getStatistics();
        }
        return null;
    }

    @Override
    public Map<StreamId, ? extends Stream> getStreams() {
        if (this.sipStreamHandler != null) {
            return this.sipStreamHandler.getStreams();
        }
        return null;
    }
}

