/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.streams.impl;

import io.pkts.frame.PcapGlobalHeader;
import io.pkts.packet.Packet;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.streams.RtpStream;
import io.pkts.streams.StreamId;
import io.pkts.streams.impl.LongStreamId;
import io.pkts.streams.impl.PacketComparator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRtpStream
implements RtpStream {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRtpStream.class);
    private final PcapGlobalHeader globalHeader;
    private final LongStreamId ssrc;
    private final NavigableSet<RtpPacket> packets;

    public DefaultRtpStream(PcapGlobalHeader globalHeader, long ssrc) {
        this.globalHeader = globalHeader;
        this.ssrc = new LongStreamId(ssrc);
        this.packets = new TreeSet<Packet>(new PacketComparator());
    }

    public void onPacket(RtpPacket msg) {
        if (msg == null) {
            return;
        }
        RtpPacket previousMsg = this.packets.isEmpty() ? null : (RtpPacket)this.packets.last();
        this.packets.add(msg);
        if (previousMsg != null && msg.getArrivalTime() < previousMsg.getArrivalTime()) {
            this.redrive();
            return;
        }
    }

    private void redrive() {
        if (logger.isInfoEnabled()) {
            logger.info("Out-of-sequence event detected. Redriving all traffic.");
        }
    }

    @Override
    public List<RtpPacket> getPackets() {
        return new ArrayList<RtpPacket>(this.packets);
    }

    @Override
    public long getDuration() {
        return 0L;
    }

    @Override
    public long getTimeOfFirstPacket() {
        if (this.packets.isEmpty()) {
            return -1L;
        }
        return ((RtpPacket)this.packets.first()).getArrivalTime();
    }

    @Override
    public long getTimeOfLastPacket() {
        if (this.packets.isEmpty()) {
            return -1L;
        }
        return ((RtpPacket)this.packets.last()).getArrivalTime();
    }

    @Override
    public StreamId getStreamIdentifier() {
        return this.ssrc;
    }

    @Override
    public void write(OutputStream out) throws IOException {
    }

    @Override
    public long getMaxJitter() {
        return 0L;
    }

    @Override
    public long getMeanJitter() {
        return 0L;
    }

    @Override
    public long getMaxDelta() {
        return 0L;
    }

    @Override
    public long getLostPackets() {
        return 0L;
    }

    @Override
    public long getSequenceErrors() {
        return 0L;
    }
}

