/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class ParametersSupport {
    private Buffer originalParams;
    private Buffer params;
    private Map<Buffer, Buffer> paramMap;
    private boolean isDirty;
    private static final int estimatedSize = 0;

    public ParametersSupport() {
        this(null);
    }

    public ParametersSupport(Buffer params) {
        if (params != null) {
            this.originalParams = params.slice();
            this.params = params;
        } else {
            this.originalParams = null;
            this.params = Buffers.EMPTY_BUFFER;
        }
    }

    public boolean hasParameters() {
        return this.originalParams != null && !this.originalParams.isEmpty() || this.paramMap != null && !this.paramMap.isEmpty();
    }

    public boolean hasParameter(Buffer name) {
        return this.paramMap != null && this.paramMap.containsKey(name);
    }

    public Buffer getParameter(Buffer name) throws SipParseException {
        if (name == null) {
            throw new IllegalArgumentException("The name of the parameter cannot be null");
        }
        if (this.paramMap != null && this.paramMap.containsKey(name)) {
            Buffer value = this.paramMap.get(name);
            if (value == null) {
                return null;
            }
            return value.slice();
        }
        return this.consumeUntil(name);
    }

    public Set<Map.Entry<Buffer, Buffer>> getAllParameters() {
        this.consumeUntil(null);
        if (this.paramMap != null) {
            return this.paramMap.entrySet();
        }
        return null;
    }

    private Buffer consumeUntil(Buffer name) {
        try {
            while (this.params.hasReadableBytes()) {
                SipParser.consumeSEMI(this.params);
                Buffer[] keyValue = SipParser.consumeGenericParam(this.params);
                this.ensureParamsMap();
                Buffer value = keyValue[1] == null ? Buffers.EMPTY_BUFFER : keyValue[1];
                this.paramMap.put(keyValue[0], value);
                if (name == null || !name.equals((Object)keyValue[0])) continue;
                return value;
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SipParseException(this.params.getReaderIndex(), "Unable to process the value due to a IndexOutOfBoundsException", e);
        }
        catch (IOException e) {
            throw new SipParseException(this.params.getReaderIndex(), "Could not read from the underlying stream while parsing the value");
        }
    }

    private void ensureParamsMap() {
        if (this.paramMap == null) {
            this.paramMap = new LinkedHashMap<Buffer, Buffer>(8);
        }
    }

    public void removeParameter(Buffer name) {
        if (this.paramMap != null) {
            this.paramMap.remove(name);
        }
    }

    public Buffer getParameter(String name) throws SipParseException {
        return this.getParameter(Buffers.wrap((String)name));
    }

    public void setParameter(String name, String value) throws SipParseException, IllegalArgumentException {
        this.setParameter(Buffers.wrap((String)name), value == null ? Buffers.EMPTY_BUFFER : Buffers.wrap((String)value));
    }

    public void setParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
        this.getParameter(name);
        this.ensureParamsMap();
        this.paramMap.put(name, PreConditions.ifNull(value, Buffers.EMPTY_BUFFER));
        this.isDirty = true;
        this.originalParams = null;
    }

    public Buffer toBuffer() {
        if (this.originalParams != null) {
            return this.originalParams.slice();
        }
        this.ensureParams();
        return this.params.slice();
    }

    private void ensureParams() {
        if (this.isDirty) {
            Buffer restOfParams = this.params;
            this.params = this.allcoateNewParamBuffer();
            for (Map.Entry<Buffer, Buffer> entry : this.paramMap.entrySet()) {
                this.params.write((byte)59);
                Buffer key = entry.getKey();
                Buffer value = entry.getValue();
                key.getBytes(0, this.params);
                if (value == null || value.isEmpty()) continue;
                this.params.write((byte)61);
                value.getBytes(0, this.params);
            }
            this.paramMap.clear();
            restOfParams.getBytes(this.params);
            this.originalParams = this.params.slice();
            this.isDirty = false;
        }
    }

    public void transferValue(Buffer dst) {
        if (this.isDirty) {
            this.ensureParams();
        }
        if (this.originalParams != null) {
            this.originalParams.getBytes(0, dst);
        } else {
            this.params.getBytes(0, dst);
        }
    }

    private Buffer allcoateNewParamBuffer() {
        return Buffers.createBuffer((int)256);
    }
}

