/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.header.impl.ToHeaderImpl;
import java.util.Random;

public interface ToHeader
extends AddressParametersHeader {
    public static final Buffer NAME = Buffers.wrap((String)"To");
    public static final Buffer COMPACT_NAME = Buffers.wrap((String)"t");

    public Buffer getTag() throws SipParseException;

    @Override
    public ToHeader clone();

    @Override
    default public ToHeader toToHeader() {
        return this;
    }

    public static ToHeader frame(Buffer buffer) throws SipParseException {
        Buffer original = buffer.slice();
        Object[] result = AddressParametersHeader.frame(buffer);
        return new ToHeaderImpl(original, (Address)result[0], (Buffer)result[1]);
    }

    public static Buffer generateTag() {
        return Buffers.wrap((String)Integer.toHexString(new Random().nextInt()));
    }

    @Override
    default public boolean isToHeader() {
        return true;
    }

    public static Builder withHost(Buffer host) {
        Builder b = new Builder();
        b.withHost(host);
        return b;
    }

    public static Builder withHost(String host) {
        return ToHeader.withHost(Buffers.wrap((String)host));
    }

    public static Builder withAddress(Address address) throws SipParseException {
        Builder builder = new Builder();
        builder.withAddress(address);
        return builder;
    }

    @Override
    public Builder copy();

    public static class Builder
    extends AddressParametersHeader.Builder<ToHeader> {
        private Builder(ParametersSupport params) {
            super(NAME, params);
        }

        private Builder() {
            super(NAME);
        }

        @Override
        public ToHeader internalBuild(Buffer rawValue, Address address, Buffer params) throws SipParseException {
            return new ToHeaderImpl(rawValue, address, params);
        }
    }
}

