/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.Transport;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.address.impl.SipURIImpl;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import io.pkts.packet.sip.impl.SipUserHostInfo;
import java.io.IOException;
import java.util.Optional;

public interface SipURI
extends URI {
    public Optional<Buffer> getUser();

    public Buffer getHost();

    public int getPort();

    @Override
    default public SipURI toSipURI() {
        return this;
    }

    public boolean isSecure();

    public Optional<Transport> getTransportParam() throws SipParseException;

    public Optional<Buffer> getUserParam() throws SipParseException;

    public int getTTLParam() throws SipParseException;

    public Optional<Buffer> getMAddrParam() throws SipParseException;

    public Optional<Buffer> getMethodParam() throws SipParseException;

    public Optional<Buffer> getParameter(Buffer var1) throws SipParseException, IllegalArgumentException;

    public Optional<Buffer> getParameter(String var1) throws SipParseException, IllegalArgumentException;

    public boolean equals(Object var1);

    @Override
    public SipURI clone();

    public Builder copy();

    public static SipURI frame(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        SipUserHostInfo userHost;
        boolean isSips;
        Buffer original = buffer.slice();
        int originalIndex = buffer.getReaderIndex();
        try {
            isSips = SipParser.isSips(buffer);
        }
        catch (SipParseException e) {
            throw new SipParseException(e.getErrorOffset() - 1, "SIP URI must start with sip: or sips:");
        }
        int userHostStartIndex = buffer.getReaderIndex();
        try {
            userHost = SipParser.consumeUserInfoHostPort(buffer);
        }
        catch (SipParseException e) {
            throw new SipParseException(userHostStartIndex + e.getErrorOffset(), e.getTemplate(), e);
        }
        Buffer port = userHost.getPort();
        if (port != null) {
            try {
                port.parseToInt();
            }
            catch (NumberFormatException e) {
                throw new SipParseException(0, "The SIP URI had a port but it was not an integer: \"" + port.toString() + "\"");
            }
        }
        return new SipURIImpl(isSips, userHost.getUser(), userHost.getHost(), port, buffer, original);
    }

    public static SipURI frame(String buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        PreConditions.assertNotEmpty(buffer, "Cannot frame a null or empty string into a SIP URI");
        return SipURI.frame(Buffers.wrap((String)buffer));
    }

    public static Builder with() {
        return new Builder();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withUser(String user) {
        Builder builder = new Builder();
        return builder.withUser(user);
    }

    public static Builder withUser(Buffer user) {
        Builder builder = new Builder();
        return builder.withUser(user);
    }

    public static Builder withHost(String host) {
        Builder builder = new Builder();
        return builder.withHost(host);
    }

    public static Builder withParameters(Buffer params) {
        ParametersSupport paramSupport = new ParametersSupport(params);
        return new Builder(paramSupport);
    }

    public static Builder withHost(Buffer host) {
        Builder builder = new Builder();
        return builder.withHost(host);
    }

    public static Builder withTemplate(SipURI uri) {
        Builder b = new Builder();
        b.withUser((Buffer)uri.getUser().orElse(null));
        b.withHost(uri.getHost());
        b.withPort(uri.getPort());
        b.withSecure(uri.isSecure());
        uri.getTransportParam().ifPresent(t -> b.withParameter(SipParser.TRANSPORT, t.toBuffer()));
        return b;
    }

    public static class Builder
    extends URI.Builder<SipURI> {
        private Buffer user;
        private Buffer host;
        private Buffer port;
        private boolean isSecure;
        private ParametersSupport paramSupport;
        private int size = 4;

        private Builder() {
            this(new ParametersSupport(null));
        }

        private Builder(ParametersSupport params) {
            this.paramSupport = params;
        }

        public Builder withUser(Buffer user) {
            if (user != null && !user.isEmpty()) {
                this.size += user.capacity() + 1 - (this.user != null ? this.user.capacity() + 1 : 0);
                this.user = user.slice();
            } else {
                this.size -= this.user != null ? this.user.capacity() + 1 : 0;
                this.user = null;
            }
            return this;
        }

        public Builder withUser(String user) {
            if (PreConditions.checkIfNotEmpty(user)) {
                this.withUser(Buffers.wrap((String)user));
            }
            return this;
        }

        public Builder withHost(Buffer host) throws SipParseException {
            PreConditions.assertNotNull(host, "Host cannot be null");
            this.size += host.capacity() - (this.host != null ? this.host.capacity() : 0);
            this.host = host.slice();
            return this;
        }

        public Builder withHost(String host) throws SipParseException {
            PreConditions.assertNotEmpty(host, "Host cannot be null or the empty string");
            return this.withHost(Buffers.wrap((String)host));
        }

        public Builder withTransport(Transport transport) throws SipParseException {
            PreConditions.assertNotNull(transport, "Transport cannot be null or empty");
            this.paramSupport.setParameter(SipParser.TRANSPORT, transport.toBuffer());
            return this;
        }

        public Builder withTransport(Buffer transport) throws SipParseException {
            Transport.of(transport);
            this.paramSupport.setParameter(SipParser.TRANSPORT, transport);
            return this;
        }

        public Builder withTransport(String transport) throws SipParseException {
            Transport.of(transport);
            this.paramSupport.setParameter(SipParser.TRANSPORT, Buffers.wrap((String)transport));
            return this;
        }

        public Builder withParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder withParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder withParameter(String name, int value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(Buffers.wrap((String)name), Buffers.wrap((int)value));
            return this;
        }

        public Builder withParameter(Buffer name, int value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, Buffers.wrap((int)value));
            return this;
        }

        public Builder withNoParameters() {
            this.paramSupport = new ParametersSupport(null);
            return this;
        }

        public Builder secure() {
            if (!this.isSecure) {
                this.isSecure = true;
                ++this.size;
            }
            return this;
        }

        public Builder withSecure(boolean secure) {
            if (secure == this.isSecure) {
                return this;
            }
            this.size = secure && !this.isSecure ? ++this.size : --this.size;
            this.isSecure = secure;
            return this;
        }

        public Builder withPort(int port) throws SipParseException {
            PreConditions.assertArgument(port > 0 || port == -1, "Port must be greater than zero or negative one (use default)");
            if (port == -1) {
                return this.withPort(null);
            }
            return this.withPort(Buffers.wrap((int)port));
        }

        public Builder withPort(Buffer port) throws SipParseException {
            if (port != null) {
                try {
                    PreConditions.assertArgument(port.parseToInt() > 0, "Port must be greater than zero or null (use default)");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.port != null) {
                this.size -= this.port.capacity() + 1;
            }
            if (port == null) {
                this.port = null;
            } else {
                this.port = port;
                this.size += this.port.capacity() + 1;
            }
            return this;
        }

        public Builder withNoPort() throws SipParseException {
            return this.withPort(null);
        }

        public Builder useUDP() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.UDP);
            return this;
        }

        public Builder useTCP() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.TCP);
            return this;
        }

        public Builder useTLS() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.TLS);
            return this;
        }

        public Builder useSCTP() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.SCTP);
            return this;
        }

        public Builder useWS() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.WS);
            return this;
        }

        public Builder useWSS() {
            this.paramSupport.setParameter(SipParser.TRANSPORT, SipParser.WSS);
            return this;
        }

        public boolean hasParameters() {
            return this.paramSupport.hasParameters();
        }

        @Override
        public SipURI build() throws SipParseException {
            PreConditions.assertNotEmpty(this.host, "Host cannot be empty");
            Buffer scheme = this.isSecure ? SipParser.SCHEME_SIPS_COLON : SipParser.SCHEME_SIP_COLON;
            Buffer params = this.paramSupport.toBuffer();
            if (params != null) {
                this.size += params.capacity();
            }
            Buffer uri = Buffers.createBuffer((int)this.size);
            this.transferbytes(uri, params);
            return new SipURIImpl(this.isSecure, this.user, this.host, this.port, params, uri);
        }

        private void transferbytes(Buffer dst, Buffer params) {
            if (this.isSecure) {
                SipParser.SCHEME_SIPS_COLON.getBytes(0, dst);
            } else {
                SipParser.SCHEME_SIP_COLON.getBytes(0, dst);
            }
            if (this.user != null) {
                this.user.getBytes(0, dst);
                dst.write((byte)64);
            }
            this.host.getBytes(0, dst);
            if (this.port != null) {
                dst.write((byte)58);
                this.port.getBytes(0, dst);
            }
            params.getBytes(0, dst);
        }
    }
}

