/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import io.pkts.packet.sip.impl.SipRequestBuilder;

public interface SipRequest
extends SipMessage {
    public URI getRequestUri() throws SipParseException;

    default public RouteHeader popRouteHeader() {
        throw new RuntimeException("No longer allowed because I'm immutable");
    }

    @Override
    public SipRequest clone();

    @Override
    default public SipRequest toRequest() throws ClassCastException {
        return this;
    }

    @Override
    default public boolean isRequest() {
        return true;
    }

    public static Builder invite(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.INVITE).withRequestURI(requestURI);
    }

    public static Builder invite(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.INVITE).withRequestURI(requestURI);
    }

    public static Builder ack(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.ACK).withRequestURI(requestURI);
    }

    public static Builder ack(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.ACK).withRequestURI(requestURI);
    }

    public static Builder cancel(SipURI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.CANCEL).withRequestURI(requestURI);
    }

    public static Builder cancel(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.CANCEL).withRequestURI(requestURI);
    }

    public static Builder bye(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.BYE).withRequestURI(requestURI);
    }

    public static Builder bye(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.BYE).withRequestURI(requestURI);
    }

    public static Builder register(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.REGISTER).withRequestURI(requestURI);
    }

    public static Builder register(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.REGISTER).withRequestURI(requestURI);
    }

    public static Builder update(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.UPDATE).withRequestURI(requestURI);
    }

    public static Builder update(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.UPDATE).withRequestURI(requestURI);
    }

    public static Builder subscribe(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.SUBSCRIBE).withRequestURI(requestURI);
    }

    public static Builder subscribe(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.SUBSCRIBE).withRequestURI(requestURI);
    }

    public static Builder notify(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.NOTIFY).withRequestURI(requestURI);
    }

    public static Builder notify(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.NOTIFY).withRequestURI(requestURI);
    }

    public static Builder publish(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.PUBLISH).withRequestURI(requestURI);
    }

    public static Builder publish(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.PUBLISH).withRequestURI(requestURI);
    }

    public static Builder info(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.INFO).withRequestURI(requestURI);
    }

    public static Builder info(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.INFO).withRequestURI(requestURI);
    }

    public static Builder options(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.OPTIONS).withRequestURI(requestURI);
    }

    public static Builder options(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.OPTIONS).withRequestURI(requestURI);
    }

    public static Builder prack(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.PRACK).withRequestURI(requestURI);
    }

    public static Builder prack(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.PRACK).withRequestURI(requestURI);
    }

    public static Builder refer(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.REFER).withRequestURI(requestURI);
    }

    public static Builder refer(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.REFER).withRequestURI(requestURI);
    }

    public static Builder message(String requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.MESSAGE).withRequestURI(requestURI);
    }

    public static Builder message(URI requestURI) throws SipParseException {
        return SipRequest.withMethod(SipParser.MESSAGE).withRequestURI(requestURI);
    }

    public static Builder request(Buffer method, String requestURI) throws SipParseException {
        return null;
    }

    public Builder copy();

    public static Builder request(Buffer method, URI requestURI) throws SipParseException {
        return null;
    }

    public static Builder withMethod(Buffer method) throws SipParseException {
        PreConditions.assertNotEmpty(method, "The method cannot be empty or null");
        return new SipRequestBuilder(method);
    }

    public static Builder withMethod(String method) throws SipParseException {
        PreConditions.assertNotEmpty(method, "The method cannot be empty or null");
        return new SipRequestBuilder(Buffers.wrap((String)method));
    }

    public static interface Builder
    extends SipMessage.Builder<SipRequest> {
        @Override
        default public SipMessage.Builder<SipRequest> toSipRequestBuilder() {
            return this;
        }

        @Override
        default public boolean isSipRequestBuilder() {
            return true;
        }

        public Builder withRequestURI(URI var1) throws SipParseException;

        public Builder withRequestURI(String var1) throws SipParseException;

        @Override
        public SipRequest build();
    }
}

